/*
 * Decompiled with CFR 0.152.
 */
package alluxio;

import alluxio.AbstractClient;
import alluxio.ClientContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.exception.ExceptionMessage;
import alluxio.exception.status.AlluxioStatusException;
import alluxio.exception.status.NotFoundException;
import alluxio.exception.status.UnavailableException;
import alluxio.grpc.ServiceType;
import alluxio.retry.CountingRetry;
import alluxio.security.user.BaseUserState;
import alluxio.util.ConfigurationUtils;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;

public final class AbstractClientTest {
    private static final String SERVICE_NAME = "Test Service Name";
    @Rule
    public ExpectedException mExpectedException = ExpectedException.none();

    @Test
    public void connectFailToDetermineMasterAddress() throws Exception {
        BaseTestClient client = new BaseTestClient(){

            public synchronized InetSocketAddress getAddress() throws UnavailableException {
                throw new UnavailableException("Failed to determine master address");
            }
        };
        this.mExpectedException.expect(UnavailableException.class);
        this.mExpectedException.expectMessage("Failed to determine address for Test Service Name");
        client.connect();
    }

    @Test
    public void unsupportedVersion() throws Exception {
        this.mExpectedException.expect(IOException.class);
        this.mExpectedException.expectMessage(ExceptionMessage.INCOMPATIBLE_VERSION.getMessage(new Object[]{SERVICE_NAME, 0, 1}));
        BaseTestClient client = new BaseTestClient(1L);
        client.checkVersion(0L);
        client.close();
    }

    @Test
    public void supportedVersion() throws Exception {
        BaseTestClient client = new BaseTestClient(1L);
        client.checkVersion(1L);
        client.close();
    }

    @Test
    public void confAddress() throws Exception {
        ClientContext context = (ClientContext)Mockito.mock(ClientContext.class);
        Mockito.when((Object)context.getClusterConf()).thenReturn((Object)new InstancedConfiguration(ConfigurationUtils.defaults()));
        final InetSocketAddress baseAddress = new InetSocketAddress("0.0.0.0", 2000);
        final InetSocketAddress confAddress = new InetSocketAddress("0.0.0.0", 2001);
        BaseTestClient client = new BaseTestClient(context){

            public synchronized InetSocketAddress getAddress() {
                return baseAddress;
            }

            public synchronized InetSocketAddress getConfAddress() {
                return confAddress;
            }
        };
        ArgumentCaptor argument = ArgumentCaptor.forClass(InetSocketAddress.class);
        ((ClientContext)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("test")}).when((Object)context)).loadConfIfNotLoaded((InetSocketAddress)argument.capture());
        ((ClientContext)Mockito.doReturn((Object)Mockito.mock(BaseUserState.class)).when((Object)context)).getUserState();
        try {
            client.connect();
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((Object)confAddress, (Object)argument.getValue());
    }

    @Test
    public void serviceNotFound() throws Exception {
        this.mExpectedException.expect(NotFoundException.class);
        TestServiceNotFoundClient client = new TestServiceNotFoundClient();
        client.checkVersion(0L);
        client.close();
    }

    private static class TestServiceNotFoundClient
    extends BaseTestClient {
        private TestServiceNotFoundClient() {
        }

        @Override
        protected long getRemoteServiceVersion() throws AlluxioStatusException {
            throw new NotFoundException("Service not found");
        }

        protected void afterConnect() throws IOException {
        }

        protected void beforeConnect() throws IOException {
        }
    }

    private static class BaseTestClient
    extends AbstractClient {
        private long mRemoteServiceVersion;

        protected BaseTestClient() {
            super(ClientContext.create((AlluxioConfiguration)new InstancedConfiguration(ConfigurationUtils.defaults())), null, () -> new CountingRetry(1));
        }

        protected BaseTestClient(ClientContext context) {
            super(context, null, () -> new CountingRetry(1));
        }

        public BaseTestClient(long remoteServiceVersion) {
            this();
            this.mRemoteServiceVersion = remoteServiceVersion;
        }

        protected ServiceType getRemoteServiceType() {
            return ServiceType.UNKNOWN_SERVICE;
        }

        protected String getServiceName() {
            return AbstractClientTest.SERVICE_NAME;
        }

        protected long getServiceVersion() {
            return 1L;
        }

        protected long getRemoteServiceVersion() throws AlluxioStatusException {
            return this.mRemoteServiceVersion;
        }
    }
}

