/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.security.Principal;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AuthenticationResult;
import net.shibboleth.idp.authn.principal.PrincipalSupportingComponent;
import net.shibboleth.utilities.java.support.annotation.Duration;
import net.shibboleth.utilities.java.support.annotation.constraint.NonNegative;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.annotation.constraint.Positive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.StorageSerializer;

public class AuthenticationFlowDescriptor
extends AbstractIdentifiableInitializableComponent
implements PrincipalSupportingComponent,
Predicate<ProfileRequestContext>,
StorageSerializer<AuthenticationResult> {
    @Nonnull
    @NotEmpty
    public static final String FLOW_ID_PREFIX = "authn/";
    public static final long STORAGE_EXPIRATION_OFFSET = 600000L;
    private boolean supportsNonBrowser = true;
    private boolean supportsPassive;
    private boolean supportsForced;
    @Nonnull
    private Predicate<ProfileRequestContext> reuseCondition = Predicates.alwaysTrue();
    @Duration
    @NonNegative
    private long lifetime;
    @Duration
    @Positive
    private long inactivityTimeout = 1800000L;
    @Nonnull
    private Subject supportedPrincipals = new Subject();
    @Nonnull
    private Predicate<ProfileRequestContext> activationCondition = Predicates.alwaysTrue();
    @Nullable
    private StorageSerializer<AuthenticationResult> resultSerializer;

    public boolean isNonBrowserSupported() {
        return this.supportsNonBrowser;
    }

    public void setNonBrowserSupported(boolean isSupported) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.supportsNonBrowser = isSupported;
    }

    public boolean isPassiveAuthenticationSupported() {
        return this.supportsPassive;
    }

    public void setPassiveAuthenticationSupported(boolean isSupported) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.supportsPassive = isSupported;
    }

    public boolean isForcedAuthenticationSupported() {
        return this.supportsForced;
    }

    public void setForcedAuthenticationSupported(boolean isSupported) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.supportsForced = isSupported;
    }

    @Nonnull
    public Predicate<ProfileRequestContext> getReuseCondition() {
        return this.reuseCondition;
    }

    public void setReuseCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.reuseCondition = (Predicate)Constraint.isNotNull(condition, (String)"Predicate cannot be null");
    }

    @Duration
    @NonNegative
    public long getLifetime() {
        return this.lifetime;
    }

    @Duration
    public void setLifetime(@Duration @NonNegative long flowLifetime) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.lifetime = Constraint.isGreaterThanOrEqual((long)0L, (long)flowLifetime, (String)"Lifetime must be greater than or equal to 0");
    }

    @Duration
    @Positive
    public long getInactivityTimeout() {
        return this.inactivityTimeout;
    }

    @Duration
    public void setInactivityTimeout(@Duration @Positive long timeout) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.inactivityTimeout = Constraint.isGreaterThan((long)0L, (long)timeout, (String)"Inactivity timeout must be greater than 0");
    }

    public boolean isResultActive(@Nonnull AuthenticationResult result) {
        Constraint.isNotNull((Object)result, (String)"AuthenticationResult cannot be null");
        Constraint.isTrue((boolean)result.getAuthenticationFlowId().equals(this.getId()), (String)"AuthenticationResult was not produced by this flow");
        long now = System.currentTimeMillis();
        if (this.getLifetime() > 0L && result.getAuthenticationInstant() + this.getLifetime() <= now) {
            return false;
        }
        return this.getInactivityTimeout() <= 0L || result.getLastActivityInstant() + this.getInactivityTimeout() > now;
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    public <T extends Principal> Set<T> getSupportedPrincipals(@Nonnull Class<T> c) {
        return this.supportedPrincipals.getPrincipals(c);
    }

    @Nonnull
    @NonnullElements
    public Collection<Principal> getSupportedPrincipals() {
        return Collections2.filter(this.supportedPrincipals.getPrincipals(), (Predicate)Predicates.notNull());
    }

    public <T extends Principal> void setSupportedPrincipals(@Nonnull @NonnullElements Collection<T> principals) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        Constraint.isNotNull(principals, (String)"Principal collection cannot be null.");
        this.supportedPrincipals.getPrincipals().clear();
        this.supportedPrincipals.getPrincipals().addAll(Collections2.filter(principals, (Predicate)Predicates.notNull()));
    }

    public void setActivationCondition(@Nonnull Predicate<ProfileRequestContext> condition) {
        this.activationCondition = (Predicate)Constraint.isNotNull(condition, (String)"Activation condition predicate cannot be null");
    }

    public boolean apply(@Nullable ProfileRequestContext input) {
        return this.activationCondition.apply((Object)input);
    }

    public void setResultSerializer(@Nonnull StorageSerializer<AuthenticationResult> serializer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.resultSerializer = (StorageSerializer)Constraint.isNotNull(serializer, (String)"StorageSerializer cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.resultSerializer == null) {
            throw new ComponentInitializationException("AuthenticationResult serializer cannot be null");
        }
    }

    @Nonnull
    @NotEmpty
    public String serialize(@Nonnull AuthenticationResult instance) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return this.resultSerializer.serialize((Object)instance);
    }

    @Nonnull
    public AuthenticationResult deserialize(long version, @Nonnull @NotEmpty String context, @Nonnull @NotEmpty String key, @Nonnull @NotEmpty String value, @Nonnull Long expiration) throws IOException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException((InitializableComponent)this);
        return (AuthenticationResult)this.resultSerializer.deserialize(version, context, key, value, expiration != null ? Long.valueOf(expiration - this.inactivityTimeout - STORAGE_EXPIRATION_OFFSET) : null);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof AuthenticationFlowDescriptor) {
            return this.getId().equals(((AuthenticationFlowDescriptor)obj).getId());
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("flowId", (Object)this.getId()).add("supportsPassive", this.supportsPassive).add("supportsForcedAuthentication", this.supportsForced).add("lifetime", this.lifetime).add("inactivityTimeout", this.inactivityTimeout).toString();
    }
}

