/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.authn;

import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;

public abstract class AbstractAuthenticationAction<InboundMessageType, OutboundMessageType>
extends AbstractProfileAction<InboundMessageType, OutboundMessageType> {
    @Nonnull
    private Function<ProfileRequestContext, AuthenticationContext> authnCtxLookupStrategy = new ChildContextLookup(AuthenticationContext.class);
    @Nullable
    private AuthenticationContext authnContext;

    public void setLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthenticationContext> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.authnCtxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Strategy cannot be null");
    }

    protected final boolean doPreExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        if (super.doPreExecute(profileRequestContext)) {
            this.authnContext = (AuthenticationContext)((Object)this.authnCtxLookupStrategy.apply(profileRequestContext));
            if (this.authnContext == null) {
                ActionSupport.buildEvent(profileRequestContext, (String)"InvalidAuthenticationContext");
                return false;
            }
            return this.doPreExecute(profileRequestContext, this.authnContext);
        }
        return false;
    }

    protected final void doExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext) {
        this.doExecute(profileRequestContext, this.authnContext);
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext<InboundMessageType, OutboundMessageType> profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
    }
}

