/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.evaluation.value.Value;
import proguard.optimize.evaluation.StoringInvocationUnit;

public class ConstantParameterFilter
extends SimplifiedVisitor
implements MemberVisitor {
    private final MemberVisitor constantParameterVisitor;

    public ConstantParameterFilter(MemberVisitor constantParameterVisitor) {
        this.constantParameterVisitor = constantParameterVisitor;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        int firstParameterIndex = (programMethod.getAccessFlags() & 8) != 0 ? 0 : 1;
        int parameterCount = ClassUtil.internalMethodParameterCount(programMethod.getDescriptor(programClass));
        for (int index = firstParameterIndex; index < parameterCount; ++index) {
            Value value = StoringInvocationUnit.getMethodParameterValue(programMethod, index);
            if (value == null || !value.isParticular()) continue;
            this.constantParameterVisitor.visitProgramMethod(programClass, programMethod);
        }
    }
}

