/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.ElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.DescriptorClassEnumeration;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ClassReferenceInitializer
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private final ClassPool programClassPool;
    private final ClassPool libraryClassPool;
    private final WarningPrinter missingClassWarningPrinter;
    private final WarningPrinter missingProgramMemberWarningPrinter;
    private final WarningPrinter missingLibraryMemberWarningPrinter;
    private final WarningPrinter dependencyWarningPrinter;
    private final MemberFinder memberFinder = new MemberFinder();

    public ClassReferenceInitializer(ClassPool programClassPool, ClassPool libraryClassPool, WarningPrinter missingClassWarningPrinter, WarningPrinter missingProgramMemberWarningPrinter, WarningPrinter missingLibraryMemberWarningPrinter, WarningPrinter dependencyWarningPrinter) {
        this.programClassPool = programClassPool;
        this.libraryClassPool = libraryClassPool;
        this.missingClassWarningPrinter = missingClassWarningPrinter;
        this.missingProgramMemberWarningPrinter = missingProgramMemberWarningPrinter;
        this.missingLibraryMemberWarningPrinter = missingLibraryMemberWarningPrinter;
        this.dependencyWarningPrinter = dependencyWarningPrinter;
    }

    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
    }

    public void visitLibraryClass(LibraryClass libraryClass) {
        libraryClass.fieldsAccept(this);
        libraryClass.methodsAccept(this);
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        programField.referencedClass = this.findReferencedClass(programClass.getName(), programField.getDescriptor(programClass));
        programField.attributesAccept(programClass, this);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.referencedClasses = this.findReferencedClasses(programClass.getName(), programMethod.getDescriptor(programClass));
        programMethod.attributesAccept(programClass, this);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        libraryField.referencedClass = this.findReferencedClass(libraryClass.getName(), libraryField.getDescriptor(libraryClass));
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        libraryMethod.referencedClasses = this.findReferencedClasses(libraryClass.getName(), libraryMethod.getDescriptor(libraryClass));
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        stringConstant.javaLangStringClass = this.findClass(clazz.getName(), "java/lang/String");
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        invokeDynamicConstant.referencedClasses = this.findReferencedClasses(clazz.getName(), invokeDynamicConstant.getType(clazz));
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        methodHandleConstant.javaLangInvokeMethodHandleClass = this.findClass(clazz.getName(), "java/lang/invoke/MethodHandle");
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        Clazz referencedClass;
        String className = refConstant.getClassName(clazz);
        if (ClassUtil.isInternalArrayType(className)) {
            className = "java/lang/Object";
        }
        if ((referencedClass = this.findClass(clazz.getName(), className)) != null) {
            String name = refConstant.getName(clazz);
            String type = refConstant.getType(clazz);
            boolean isFieldRef = refConstant.getTag() == 9;
            refConstant.referencedMember = this.memberFinder.findMember(clazz, referencedClass, name, type, isFieldRef);
            refConstant.referencedClass = this.memberFinder.correspondingClass();
            if (refConstant.referencedMember == null) {
                boolean isProgramClass = referencedClass instanceof ProgramClass;
                WarningPrinter missingMemberWarningPrinter = isProgramClass ? this.missingProgramMemberWarningPrinter : this.missingLibraryMemberWarningPrinter;
                missingMemberWarningPrinter.print(clazz.getName(), className, "Warning: " + ClassUtil.externalClassName(clazz.getName()) + ": can't find referenced " + (isFieldRef ? "field '" + ClassUtil.externalFullFieldDescription(0, name, type) : "method '" + ClassUtil.externalFullMethodDescription(className, 0, name, type)) + "' in " + (isProgramClass ? "program" : "library") + " class " + ClassUtil.externalClassName(className));
            }
        }
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        String className = clazz.getName();
        classConstant.referencedClass = this.findClass(className, ClassUtil.internalClassNameFromClassType(classConstant.getName(clazz)));
        classConstant.javaLangClassClass = this.findClass(className, "java/lang/Class");
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        methodTypeConstant.javaLangInvokeMethodTypeClass = this.findClass(clazz.getName(), "java/lang/invoke/MethodType");
        methodTypeConstant.referencedClasses = this.findReferencedClasses(clazz.getName(), methodTypeConstant.getType(clazz));
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        String className = clazz.getName();
        String enclosingClassName = enclosingMethodAttribute.getClassName(clazz);
        enclosingMethodAttribute.referencedClass = this.findClass(className, enclosingClassName);
        if (enclosingMethodAttribute.referencedClass != null && enclosingMethodAttribute.u2nameAndTypeIndex != 0) {
            String name = enclosingMethodAttribute.getName(clazz);
            String type = enclosingMethodAttribute.getType(clazz);
            enclosingMethodAttribute.referencedMethod = enclosingMethodAttribute.referencedClass.findMethod(name, type);
            if (enclosingMethodAttribute.referencedMethod == null) {
                this.missingProgramMemberWarningPrinter.print(className, enclosingClassName, "Warning: " + ClassUtil.externalClassName(className) + ": can't find enclosing method '" + ClassUtil.externalFullMethodDescription(enclosingClassName, 0, name, type) + "' in program class " + ClassUtil.externalClassName(enclosingClassName));
            }
        }
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        signatureAttribute.referencedClasses = this.findReferencedClasses(clazz.getName(), signatureAttribute.getSignature(clazz));
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        localVariableInfo.referencedClass = this.findReferencedClass(clazz.getName(), localVariableInfo.getDescriptor(clazz));
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        localVariableTypeInfo.referencedClasses = this.findReferencedClasses(clazz.getName(), localVariableTypeInfo.getSignature(clazz));
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        annotation.referencedClasses = this.findReferencedClasses(clazz.getName(), annotation.getType(clazz));
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        this.initializeElementValue(clazz, annotation, constantElementValue);
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        this.initializeElementValue(clazz, annotation, enumConstantElementValue);
        enumConstantElementValue.referencedClasses = this.findReferencedClasses(clazz.getName(), enumConstantElementValue.getTypeName(clazz));
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        this.initializeElementValue(clazz, annotation, classElementValue);
        classElementValue.referencedClasses = this.findReferencedClasses(clazz.getName(), classElementValue.getClassName(clazz));
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        this.initializeElementValue(clazz, annotation, annotationElementValue);
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        this.initializeElementValue(clazz, annotation, arrayElementValue);
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void initializeElementValue(Clazz clazz, Annotation annotation, ElementValue elementValue) {
        if (annotation != null && annotation.referencedClasses != null && elementValue.u2elementNameIndex != 0) {
            Clazz referencedClass;
            String name = elementValue.getMethodName(clazz);
            elementValue.referencedClass = referencedClass = annotation.referencedClasses[0];
            elementValue.referencedMethod = referencedClass.findMethod(name, null);
        }
    }

    private Clazz findReferencedClass(String referencingClassName, String descriptor) {
        DescriptorClassEnumeration enumeration = new DescriptorClassEnumeration(descriptor);
        enumeration.nextFluff();
        if (enumeration.hasMoreClassNames()) {
            return this.findClass(referencingClassName, enumeration.nextClassName());
        }
        return null;
    }

    private Clazz[] findReferencedClasses(String referencingClassName, String descriptor) {
        DescriptorClassEnumeration enumeration = new DescriptorClassEnumeration(descriptor);
        int classCount = enumeration.classCount();
        if (classCount > 0) {
            Clazz[] referencedClasses = new Clazz[classCount];
            boolean foundReferencedClasses = false;
            for (int index = 0; index < classCount; ++index) {
                String fluff = enumeration.nextFluff();
                String name = enumeration.nextClassName();
                Clazz referencedClass = this.findClass(referencingClassName, name);
                if (referencedClass == null) continue;
                referencedClasses[index] = referencedClass;
                foundReferencedClasses = true;
            }
            if (foundReferencedClasses) {
                return referencedClasses;
            }
        }
        return null;
    }

    private Clazz findClass(String referencingClassName, String name) {
        Clazz clazz;
        if (ClassUtil.isInternalArrayType(name)) {
            if (!ClassUtil.isInternalClassType(name)) {
                return null;
            }
            name = ClassUtil.internalClassNameFromClassType(name);
        }
        if ((clazz = this.programClassPool.getClass(name)) == null) {
            clazz = this.libraryClassPool.getClass(name);
            if (clazz == null && this.missingClassWarningPrinter != null) {
                this.missingClassWarningPrinter.print(referencingClassName, name, "Warning: " + ClassUtil.externalClassName(referencingClassName) + ": can't find referenced class " + ClassUtil.externalClassName(name));
            }
        } else if (this.dependencyWarningPrinter != null) {
            this.dependencyWarningPrinter.print(referencingClassName, name, "Warning: library class " + ClassUtil.externalClassName(referencingClassName) + " depends on program class " + ClassUtil.externalClassName(name));
        }
        return clazz;
    }
}

