/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.util;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.ParameterVisitor;

public class AllParameterVisitor
implements MemberVisitor {
    private final ParameterVisitor parameterVisitor;

    public AllParameterVisitor(ParameterVisitor parameterVisitor) {
        this.parameterVisitor = parameterVisitor;
    }

    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        this.visitFieldType(programClass, programField, programField.referencedClass);
    }

    public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        this.visitFieldType(libraryClass, libraryField, libraryField.referencedClass);
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        this.visitParameters(programClass, programMethod, programMethod.referencedClasses);
    }

    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        this.visitParameters(libraryClass, libraryMethod, libraryMethod.referencedClasses);
    }

    private void visitFieldType(Clazz clazz, Field field, Clazz referencedClass) {
        String descriptor = field.getDescriptor(clazz);
        this.parameterVisitor.visitParameter(clazz, field, 0, 1, 0, ClassUtil.internalTypeSize(descriptor), descriptor, referencedClass);
    }

    private void visitParameters(Clazz clazz, Method method, Clazz[] referencedClasses) {
        String descriptor = method.getDescriptor(clazz);
        int parameterCount = 0;
        int parameterSize = 0;
        int index = 1;
        block12: while (true) {
            char c = descriptor.charAt(index++);
            switch (c) {
                case 'D': 
                case 'J': {
                    ++parameterSize;
                    break;
                }
                default: {
                    break;
                }
                case 'L': {
                    index = descriptor.indexOf(59, index) + 1;
                    break;
                }
                case '[': {
                    while ((c = descriptor.charAt(index++)) == '[') {
                    }
                    if (c != 'L') break;
                    index = descriptor.indexOf(59, index) + 1;
                    break;
                }
                case ')': {
                    break block12;
                }
            }
            ++parameterCount;
            ++parameterSize;
        }
        int parameterIndex = 0;
        int parameterOffset = 0;
        int referenceClassIndex = 0;
        index = 1;
        while (true) {
            int newIndex = index + 1;
            int thisParameterSize = 1;
            Clazz referencedClass = null;
            char c = descriptor.charAt(index);
            switch (c) {
                case 'D': 
                case 'J': {
                    thisParameterSize = 2;
                    break;
                }
                default: {
                    break;
                }
                case 'L': {
                    newIndex = descriptor.indexOf(59, newIndex) + 1;
                    referencedClass = referencedClasses == null ? null : referencedClasses[referenceClassIndex++];
                    break;
                }
                case '[': {
                    while ((c = descriptor.charAt(newIndex++)) == '[') {
                    }
                    if (c != 'L') break;
                    newIndex = descriptor.indexOf(59, newIndex) + 1;
                    referencedClass = referencedClasses == null ? null : referencedClasses[referenceClassIndex++];
                    break;
                }
                case ')': {
                    return;
                }
            }
            this.parameterVisitor.visitParameter(clazz, method, parameterIndex++, parameterCount, parameterOffset, parameterSize, descriptor.substring(index, newIndex), referencedClass);
            index = newIndex;
            parameterOffset += thisParameterSize;
        }
    }
}

