/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class VariableInstruction
extends Instruction {
    public boolean wide;
    public int variableIndex;
    public int constant;

    public VariableInstruction() {
    }

    public VariableInstruction(boolean wide) {
        this.wide = wide;
    }

    public VariableInstruction(byte opcode) {
        this(opcode, VariableInstruction.embeddedVariable(opcode), 0);
    }

    public VariableInstruction(byte opcode, int variableIndex) {
        this(opcode, variableIndex, 0);
    }

    public VariableInstruction(byte opcode, int variableIndex, int constant) {
        this.opcode = opcode;
        this.variableIndex = variableIndex;
        this.constant = constant;
        this.wide = this.requiredVariableIndexSize() > 1 || this.requiredConstantSize() > 1;
    }

    public VariableInstruction copy(VariableInstruction variableInstruction) {
        this.opcode = variableInstruction.opcode;
        this.variableIndex = variableInstruction.variableIndex;
        this.constant = variableInstruction.constant;
        this.wide = variableInstruction.wide;
        return this;
    }

    private static int embeddedVariable(byte opcode) {
        switch (opcode) {
            case 27: 
            case 31: 
            case 35: 
            case 39: 
            case 43: 
            case 60: 
            case 64: 
            case 68: 
            case 72: 
            case 76: {
                return 1;
            }
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 61: 
            case 65: 
            case 69: 
            case 73: 
            case 77: {
                return 2;
            }
            case 29: 
            case 33: 
            case 37: 
            case 41: 
            case 45: 
            case 62: 
            case 66: 
            case 70: 
            case 74: 
            case 78: {
                return 3;
            }
        }
        return 0;
    }

    public boolean isStore() {
        return this.opcode >= 54 || this.opcode == -124;
    }

    public boolean isLoad() {
        return this.opcode < 54;
    }

    public byte canonicalOpcode() {
        switch (this.opcode) {
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return 21;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return 22;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return 23;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                return 24;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                return 25;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                return 54;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                return 55;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                return 56;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                return 57;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return 58;
            }
        }
        return this.opcode;
    }

    public Instruction shrink() {
        this.opcode = this.canonicalOpcode();
        if (this.variableIndex <= 3) {
            switch (this.opcode) {
                case 21: {
                    this.opcode = (byte)(26 + this.variableIndex);
                    break;
                }
                case 22: {
                    this.opcode = (byte)(30 + this.variableIndex);
                    break;
                }
                case 23: {
                    this.opcode = (byte)(34 + this.variableIndex);
                    break;
                }
                case 24: {
                    this.opcode = (byte)(38 + this.variableIndex);
                    break;
                }
                case 25: {
                    this.opcode = (byte)(42 + this.variableIndex);
                    break;
                }
                case 54: {
                    this.opcode = (byte)(59 + this.variableIndex);
                    break;
                }
                case 55: {
                    this.opcode = (byte)(63 + this.variableIndex);
                    break;
                }
                case 56: {
                    this.opcode = (byte)(67 + this.variableIndex);
                    break;
                }
                case 57: {
                    this.opcode = (byte)(71 + this.variableIndex);
                    break;
                }
                case 58: {
                    this.opcode = (byte)(75 + this.variableIndex);
                }
            }
        }
        this.wide = this.requiredVariableIndexSize() > 1 || this.requiredConstantSize() > 1;
        return this;
    }

    protected boolean isWide() {
        return this.wide;
    }

    protected void readInfo(byte[] code, int offset) {
        int variableIndexSize = this.variableIndexSize();
        int constantSize = this.constantSize();
        if (variableIndexSize == 0) {
            this.variableIndex = this.opcode < 59 ? this.opcode - 26 & 3 : this.opcode - 59 & 3;
        } else {
            this.variableIndex = VariableInstruction.readValue(code, offset, variableIndexSize);
            offset += variableIndexSize;
        }
        this.constant = VariableInstruction.readSignedValue(code, offset, constantSize);
    }

    protected void writeInfo(byte[] code, int offset) {
        int variableIndexSize = this.variableIndexSize();
        int constantSize = this.constantSize();
        if (this.requiredVariableIndexSize() > variableIndexSize) {
            throw new IllegalArgumentException("Instruction has invalid variable index size (" + this.toString(offset) + ")");
        }
        if (this.requiredConstantSize() > constantSize) {
            throw new IllegalArgumentException("Instruction has invalid constant size (" + this.toString(offset) + ")");
        }
        VariableInstruction.writeValue(code, offset, this.variableIndex, variableIndexSize);
        VariableInstruction.writeSignedValue(code, offset += variableIndexSize, this.constant, constantSize);
    }

    public int length(int offset) {
        return (this.wide ? 2 : 1) + this.variableIndexSize() + this.constantSize();
    }

    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitVariableInstruction(clazz, method, codeAttribute, offset, this);
    }

    public String toString() {
        return this.getName() + (this.wide ? "_w" : "") + " v" + this.variableIndex + (this.constantSize() > 0 ? ", " + this.constant : "");
    }

    private int variableIndexSize() {
        return this.opcode >= 26 && this.opcode <= 45 || this.opcode >= 59 && this.opcode <= 78 ? 0 : (this.wide ? 2 : 1);
    }

    private int requiredVariableIndexSize() {
        return (this.variableIndex & 3) == this.variableIndex ? 0 : ((this.variableIndex & 0xFF) == this.variableIndex ? 1 : ((this.variableIndex & 0xFFFF) == this.variableIndex ? 2 : 4));
    }

    private int constantSize() {
        return this.opcode != -124 ? 0 : (this.wide ? 2 : 1);
    }

    private int requiredConstantSize() {
        return this.opcode != -124 ? 0 : ((byte)this.constant == this.constant ? 1 : ((short)this.constant == this.constant ? 2 : 4));
    }
}

