/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.io.PrintStream;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.SimpleClassPrinter;
import proguard.optimize.KeepMarker;
import proguard.optimize.KeptClassFilter;
import proguard.optimize.KeptMemberFilter;

public class SeedPrinter {
    private final PrintStream ps;

    public SeedPrinter(PrintStream ps) throws IOException {
        this.ps = ps;
    }

    public void write(Configuration configuration, ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        if (configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolvisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(configuration.keep, keepMarker, keepMarker, true, true, true);
        programClassPool.accept(classPoolvisitor);
        libraryClassPool.accept(classPoolvisitor);
        SimpleClassPrinter printer = new SimpleClassPrinter(false, this.ps);
        programClassPool.classesAcceptAlphabetically(new MultiClassVisitor(new ClassVisitor[]{new KeptClassFilter(printer), new AllMemberVisitor(new KeptMemberFilter(printer))}));
    }
}

