/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.rest.utils;

import io.restassured.filter.log.LogDetail;
import io.restassured.internal.print.ResponsePrinter;
import io.restassured.response.Response;
import io.restassured.response.ResponseBody;
import io.restassured.response.ResponseOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class RestResponseRecordingHelper {
    private final List<LogDetail> logDetail = new LinkedList<LogDetail>();
    private final boolean shouldPrettyPrint;

    public RestResponseRecordingHelper(boolean shouldPrettyPrint, LogDetail ... details) {
        this.logDetail.addAll(Arrays.asList(details));
        this.shouldPrettyPrint = shouldPrettyPrint;
    }

    public Map<LogDetail, String> print(Response response) {
        HashMap<LogDetail, String> result = new HashMap<LogDetail, String>();
        if (response != null) {
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 PrintStream recordingStream = new PrintStream((OutputStream)output, true, StandardCharsets.UTF_8.toString());){
                for (LogDetail detail : this.logDetail) {
                    try {
                        ResponsePrinter.print((ResponseOptions)response, (ResponseBody)response.getBody(), (PrintStream)recordingStream, (LogDetail)detail, (boolean)this.shouldPrettyPrint);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    recordingStream.flush();
                    String recorded = new String(output.toByteArray(), StandardCharsets.UTF_8);
                    output.reset();
                    recorded = recorded.replaceAll("^((Proxy:)|(Body:)|(Cookies:)|(Headers:)|(Multiparts:)|(Request path:))\\s*\\n*", "");
                    recorded = recorded.replaceAll("^(<none>)", "");
                    recorded = recorded.replaceAll("\n$", "");
                    result.put(detail, recorded);
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Incorrect implementation, should be used correct charset", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Some exception during recording fields", e);
            }
        }
        return result;
    }
}

