/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.json;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Map;
import net.revelc.code.formatter.AbstractCacheableFormatter;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.Formatter;
import net.revelc.code.formatter.LineEnding;

public class JsonFormatter
extends AbstractCacheableFormatter
implements Formatter {
    private ObjectMapper formatter;

    @Override
    public void init(Map<String, String> options, ConfigurationSource cfg) {
        super.initCfg(cfg);
        int indent = Integer.parseInt(options.getOrDefault("indent", "4"));
        String lineEnding = options.getOrDefault("lineending", System.lineSeparator());
        final boolean spaceBeforeSeparator = Boolean.parseBoolean(options.getOrDefault("spaceBeforeSeparator", "true"));
        boolean useAlphabeticalOrder = Boolean.parseBoolean(options.getOrDefault("alphabeticalOrder", "false"));
        this.formatter = new ObjectMapper();
        DefaultIndenter indenter = new DefaultIndenter(Strings.repeat((String)" ", (int)indent), lineEnding);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter(){
            private static final long serialVersionUID = 1L;

            public DefaultPrettyPrinter createInstance() {
                return new DefaultPrettyPrinter((DefaultPrettyPrinter)this);
            }

            public DefaultPrettyPrinter withSeparators(Separators separators) {
                this._separators = separators;
                this._objectFieldValueSeparatorWithSpaces = (spaceBeforeSeparator ? " " : "") + separators.getObjectFieldValueSeparator() + " ";
                return this;
            }
        };
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        this.formatter.setDefaultPrettyPrinter((PrettyPrinter)printer);
        this.formatter.enable(SerializationFeature.INDENT_OUTPUT);
        this.formatter.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, useAlphabeticalOrder);
    }

    @Override
    protected String doFormat(String code, LineEnding ending) throws IOException {
        Object json = this.formatter.readValue(code, Object.class);
        String formattedCode = this.formatter.writer().writeValueAsString(json);
        if (code.equals(formattedCode = formattedCode + ending.getChars())) {
            return null;
        }
        return formattedCode;
    }

    @Override
    public boolean isInitialized() {
        return this.formatter != null;
    }
}

