/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.mask;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.logstash.logback.mask.ValueMasker;
import tools.jackson.core.TokenStreamContext;

public class RegexValueMasker
implements ValueMasker {
    private final Pattern pattern;
    private final Object mask;

    public RegexValueMasker(String regex, Object mask) {
        this(Pattern.compile(regex), mask);
    }

    public RegexValueMasker(Pattern pattern, Object mask) {
        this.pattern = Objects.requireNonNull(pattern, "pattern must not be null");
        this.mask = Objects.requireNonNull(mask, "mask must not be null");
    }

    @Override
    public Object mask(TokenStreamContext context, Object o) {
        if (o instanceof CharSequence) {
            Matcher matcher = this.pattern.matcher((CharSequence)o);
            if (this.mask instanceof String) {
                String replaced = matcher.replaceAll((String)this.mask);
                if (replaced != o) {
                    return replaced;
                }
            } else if (matcher.matches()) {
                return this.mask;
            }
        }
        return null;
    }
}

