/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.encoder.com.lmax.disruptor.dsl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ThreadFactory;
import net.logstash.logback.encoder.com.lmax.disruptor.EventHandlerIdentity;
import net.logstash.logback.encoder.com.lmax.disruptor.EventProcessor;
import net.logstash.logback.encoder.com.lmax.disruptor.Sequence;
import net.logstash.logback.encoder.com.lmax.disruptor.SequenceBarrier;
import net.logstash.logback.encoder.com.lmax.disruptor.dsl.ConsumerInfo;
import net.logstash.logback.encoder.com.lmax.disruptor.dsl.EventProcessorInfo;

class ConsumerRepository {
    private final Map<EventHandlerIdentity, EventProcessorInfo> eventProcessorInfoByEventHandler = new IdentityHashMap<EventHandlerIdentity, EventProcessorInfo>();
    private final Map<Sequence, ConsumerInfo> eventProcessorInfoBySequence = new IdentityHashMap<Sequence, ConsumerInfo>();
    private final Collection<ConsumerInfo> consumerInfos = new ArrayList<ConsumerInfo>();

    ConsumerRepository() {
    }

    public void add(EventProcessor eventprocessor, EventHandlerIdentity handlerIdentity, SequenceBarrier barrier) {
        EventProcessorInfo consumerInfo = new EventProcessorInfo(eventprocessor, barrier);
        this.eventProcessorInfoByEventHandler.put(handlerIdentity, consumerInfo);
        this.eventProcessorInfoBySequence.put(eventprocessor.getSequence(), consumerInfo);
        this.consumerInfos.add(consumerInfo);
    }

    public void add(EventProcessor processor) {
        EventProcessorInfo consumerInfo = new EventProcessorInfo(processor, null);
        this.eventProcessorInfoBySequence.put(processor.getSequence(), consumerInfo);
        this.consumerInfos.add(consumerInfo);
    }

    public void startAll(ThreadFactory threadFactory) {
        this.consumerInfos.forEach(c -> c.start(threadFactory));
    }

    public void haltAll() {
        this.consumerInfos.forEach(ConsumerInfo::halt);
    }

    public boolean hasBacklog(long cursor, boolean includeStopped) {
        for (ConsumerInfo consumerInfo : this.consumerInfos) {
            Sequence[] sequences;
            if (!includeStopped && !consumerInfo.isRunning() || !consumerInfo.isEndOfChain()) continue;
            for (Sequence sequence : sequences = consumerInfo.getSequences()) {
                if (cursor <= sequence.get()) continue;
                return true;
            }
        }
        return false;
    }

    public EventProcessor getEventProcessorFor(EventHandlerIdentity handlerIdentity) {
        EventProcessorInfo eventprocessorInfo = this.getEventProcessorInfo(handlerIdentity);
        if (eventprocessorInfo == null) {
            throw new IllegalArgumentException("The event handler " + handlerIdentity + " is not processing events.");
        }
        return eventprocessorInfo.getEventProcessor();
    }

    public Sequence getSequenceFor(EventHandlerIdentity handlerIdentity) {
        return this.getEventProcessorFor(handlerIdentity).getSequence();
    }

    public void unMarkEventProcessorsAsEndOfChain(Sequence ... barrierEventProcessors) {
        for (Sequence barrierEventProcessor : barrierEventProcessors) {
            this.getEventProcessorInfo(barrierEventProcessor).markAsUsedInBarrier();
        }
    }

    public SequenceBarrier getBarrierFor(EventHandlerIdentity handlerIdentity) {
        EventProcessorInfo consumerInfo = this.getEventProcessorInfo(handlerIdentity);
        return consumerInfo != null ? consumerInfo.getBarrier() : null;
    }

    private EventProcessorInfo getEventProcessorInfo(EventHandlerIdentity handlerIdentity) {
        return this.eventProcessorInfoByEventHandler.get(handlerIdentity);
    }

    private ConsumerInfo getEventProcessorInfo(Sequence barrierEventProcessor) {
        return this.eventProcessorInfoBySequence.get(barrierEventProcessor);
    }
}

