/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import java.util.regex.Pattern;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.encoder.SeparatorParser;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import tools.jackson.core.JsonGenerator;

public class MessageJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_MESSAGE = "message";
    private Pattern messageSplitPattern = null;

    public MessageJsonProvider() {
        this.setFieldName(FIELD_MESSAGE);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) {
        if (this.messageSplitPattern != null) {
            String[] multiLineMessage = this.messageSplitPattern.split(event.getFormattedMessage());
            JsonWritingUtils.writeStringArrayField(generator, this.getFieldName(), multiLineMessage);
        } else {
            JsonWritingUtils.writeStringField(generator, this.getFieldName(), event.getFormattedMessage());
        }
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getMessage());
    }

    public String getMessageSplitRegex() {
        return this.messageSplitPattern != null ? this.messageSplitPattern.pattern() : null;
    }

    public void setMessageSplitRegex(String messageSplitRegex) {
        String parsedMessageSplitRegex = SeparatorParser.parseSeparator(messageSplitRegex);
        this.messageSplitPattern = parsedMessageSplitRegex != null ? Pattern.compile(parsedMessageSplitRegex) : null;
    }
}

