/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.fieldnames.LogstashFieldNames;
import tools.jackson.core.JsonGenerator;

public class CallerDataJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_CALLER_CLASS_NAME = "caller_class_name";
    public static final String FIELD_CALLER_METHOD_NAME = "caller_method_name";
    public static final String FIELD_CALLER_FILE_NAME = "caller_file_name";
    public static final String FIELD_CALLER_LINE_NUMBER = "caller_line_number";
    private String classFieldName = "caller_class_name";
    private String methodFieldName = "caller_method_name";
    private String fileFieldName = "caller_file_name";
    private String lineFieldName = "caller_line_number";

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) {
        StackTraceElement callerData = this.extractCallerData(event);
        if (callerData == null) {
            return;
        }
        if (this.getFieldName() != null) {
            generator.writeObjectPropertyStart(this.getFieldName());
        }
        JsonWritingUtils.writeStringField(generator, this.classFieldName, callerData.getClassName());
        JsonWritingUtils.writeStringField(generator, this.methodFieldName, callerData.getMethodName());
        JsonWritingUtils.writeStringField(generator, this.fileFieldName, callerData.getFileName());
        JsonWritingUtils.writeNumberField(generator, this.lineFieldName, callerData.getLineNumber());
        if (this.getFieldName() != null) {
            generator.writeEndObject();
        }
    }

    @Override
    public void prepareForDeferredProcessing(ILoggingEvent event) {
        super.prepareForDeferredProcessing(event);
        event.getCallerData();
    }

    private StackTraceElement extractCallerData(ILoggingEvent event) {
        StackTraceElement[] ste = event.getCallerData();
        if (ste == null || ste.length == 0) {
            return null;
        }
        return ste[0];
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getCaller());
        this.setClassFieldName(fieldNames.getCallerClass());
        this.setMethodFieldName(fieldNames.getCallerMethod());
        this.setFileFieldName(fieldNames.getCallerFile());
        this.setLineFieldName(fieldNames.getCallerLine());
    }

    public String getClassFieldName() {
        return this.classFieldName;
    }

    public void setClassFieldName(String callerClassFieldName) {
        this.classFieldName = callerClassFieldName;
    }

    public String getMethodFieldName() {
        return this.methodFieldName;
    }

    public void setMethodFieldName(String callerMethodFieldName) {
        this.methodFieldName = callerMethodFieldName;
    }

    public String getFileFieldName() {
        return this.fileFieldName;
    }

    public void setFileFieldName(String callerFileFieldName) {
        this.fileFieldName = callerFileFieldName;
    }

    public String getLineFieldName() {
        return this.lineFieldName;
    }

    public void setLineFieldName(String callerLineFieldName) {
        this.lineFieldName = callerLineFieldName;
    }
}

