/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.jca;

import java.io.ByteArrayOutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.SignatureException;
import net.jsign.jca.AbstractSignatureSpi;
import net.jsign.jca.SigningServicePrivateKey;

class SigningServiceSignature
extends AbstractSignatureSpi {
    private SigningServicePrivateKey privateKey;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public SigningServiceSignature(String signingAlgorithm) {
        super(signingAlgorithm);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) {
        this.privateKey = (SigningServicePrivateKey)privateKey;
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) {
        this.buffer.write(b, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        try {
            return this.privateKey.getService().sign(this.privateKey, this.signingAlgorithm, this.buffer.toByteArray());
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
    }
}

