/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.zip;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import net.jsign.ChannelUtils;
import net.jsign.zip.CentralDirectory;
import net.jsign.zip.CentralDirectoryFileHeader;
import net.jsign.zip.LocalFileHeader;
import net.jsign.zip.Zip64ExtendedInfoExtraField;
import org.apache.commons.io.input.BoundedInputStream;

public class ZipFile
implements Closeable {
    protected final SeekableByteChannel channel;
    protected CentralDirectory centralDirectory;

    public ZipFile(File file) throws IOException {
        this(Files.newByteChannel(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE));
    }

    public ZipFile(SeekableByteChannel channel) throws IOException {
        this.channel = channel;
        this.centralDirectory = new CentralDirectory();
        this.centralDirectory.read(channel);
    }

    public InputStream getInputStream(String name) throws IOException {
        return this.getInputStream(name, -1);
    }

    public InputStream getInputStream(String name, int limit) throws IOException {
        CentralDirectoryFileHeader header = this.centralDirectory.entries.get(name);
        if (header == null) {
            throw new IOException("Entry not found: " + name);
        }
        if (limit != -1 && header.getUncompressedSize() > (long)limit) {
            throw new IOException("The entry " + name + " is too large to be read (" + header.getUncompressedSize() + " bytes)");
        }
        this.channel.position(header.getLocalHeaderOffset());
        LocalFileHeader localFileHeader = new LocalFileHeader();
        localFileHeader.read(this.channel);
        InputStream in = Channels.newInputStream(this.channel);
        in = new BoundedInputStream(in, header.getCompressedSize());
        switch (header.compressionMethod) {
            case 0: {
                return in;
            }
            case 8: {
                Inflater inflater = new Inflater(true);
                return new InflaterInputStream(in, inflater);
            }
        }
        throw new IOException("Unsupported compression method " + header.compressionMethod + " for entry " + name);
    }

    public void addEntry(String name, byte[] data, boolean compressed) throws IOException {
        int compressedSize;
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        int uncompressedSize = data.length;
        if (compressed) {
            Deflater deflater = new Deflater(9, true);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)bos, deflater);
            dos.write(data);
            dos.flush();
            dos.close();
            data = bos.toByteArray();
            compressedSize = data.length;
        } else {
            compressedSize = uncompressedSize;
        }
        LocalFileHeader localFileHeader = new LocalFileHeader();
        localFileHeader.versionNeededToExtract = 20;
        localFileHeader.generalPurposeBitFlag = 0;
        localFileHeader.compressionMethod = compressed ? 8 : 0;
        localFileHeader.lastModFileTime = 0;
        localFileHeader.lastModFileDate = 33;
        localFileHeader.crc32 = (int)crc32.getValue();
        localFileHeader.compressedSize = compressedSize;
        localFileHeader.uncompressedSize = uncompressedSize;
        localFileHeader.fileName = name.getBytes(StandardCharsets.UTF_8);
        this.channel.position(this.centralDirectory.centralDirectoryOffset);
        long offset = this.channel.position();
        localFileHeader.write(this.channel);
        this.channel.write(ByteBuffer.wrap(data));
        boolean needsZip64 = offset > 0xFFFFFFFFL;
        CentralDirectoryFileHeader centralDirectoryFileHeader = new CentralDirectoryFileHeader();
        centralDirectoryFileHeader.versionMadeBy = 45;
        centralDirectoryFileHeader.versionNeededToExtract = 20;
        centralDirectoryFileHeader.generalPurposeBitFlag = localFileHeader.generalPurposeBitFlag;
        centralDirectoryFileHeader.compressionMethod = localFileHeader.compressionMethod;
        centralDirectoryFileHeader.lastModFileTime = localFileHeader.lastModFileTime;
        centralDirectoryFileHeader.lastModFileDate = localFileHeader.lastModFileDate;
        centralDirectoryFileHeader.crc32 = localFileHeader.crc32;
        centralDirectoryFileHeader.compressedSize = localFileHeader.compressedSize;
        centralDirectoryFileHeader.uncompressedSize = uncompressedSize;
        centralDirectoryFileHeader.diskNumberStart = 0;
        centralDirectoryFileHeader.internalFileAttributes = 0;
        centralDirectoryFileHeader.externalFileAttributes = 0;
        centralDirectoryFileHeader.localHeaderOffset = needsZip64 ? 0xFFFFFFFFL : offset;
        centralDirectoryFileHeader.fileName = localFileHeader.fileName;
        if (needsZip64) {
            Zip64ExtendedInfoExtraField zip64ExtraField = new Zip64ExtendedInfoExtraField(-1L, -1L, offset, -1);
            centralDirectoryFileHeader.extraFields.put(zip64ExtraField.id, zip64ExtraField);
        }
        this.centralDirectory.entries.put(name, centralDirectoryFileHeader);
        this.centralDirectory.write(this.channel);
    }

    public void renameEntry(String oldName, String newName) throws IOException {
        if (oldName.length() != newName.length()) {
            throw new IllegalArgumentException("The new name must have the same length");
        }
        CentralDirectoryFileHeader centralDirectoryFileHeader = this.centralDirectory.entries.get(oldName);
        centralDirectoryFileHeader.fileName = newName.getBytes(StandardCharsets.UTF_8);
        this.centralDirectory.entries.remove(oldName);
        this.centralDirectory.entries.put(newName, centralDirectoryFileHeader);
        long offset = centralDirectoryFileHeader.getLocalHeaderOffset();
        this.channel.position(offset);
        LocalFileHeader localFileHeader = new LocalFileHeader();
        localFileHeader.read(this.channel);
        localFileHeader.fileName = newName.getBytes(StandardCharsets.UTF_8);
        this.channel.position(offset);
        localFileHeader.write(this.channel);
        this.channel.position(this.centralDirectory.centralDirectoryOffset);
        this.centralDirectory.write(this.channel);
    }

    public void removeEntry(String name) throws IOException {
        CentralDirectoryFileHeader centralDirectoryFileHeader = this.centralDirectory.entries.get(name);
        ChannelUtils.delete(this.channel, centralDirectoryFileHeader.getLocalHeaderOffset(), this.centralDirectory.getEntrySize(name));
        this.centralDirectory.removeEntry(name);
        this.channel.position(this.centralDirectory.centralDirectoryOffset);
        this.centralDirectory.write(this.channel);
        this.channel.truncate(this.channel.position());
    }

    @Override
    public void close() throws IOException {
        if (this.channel != null) {
            this.channel.close();
        }
    }
}

