/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.zip;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jsign.zip.Zip64ExtendedInfoExtraField;

class ExtraField {
    public int id;
    public byte[] data = new byte[0];

    ExtraField() {
    }

    public void read(ByteBuffer buffer) throws IOException {
        this.id = buffer.getShort() & 0xFFFF;
        int size = buffer.getShort() & 0xFFFF;
        if (size > buffer.remaining()) {
            throw new IOException("Invalid extra field size");
        }
        if (size > 0) {
            this.data = new byte[size];
            buffer.get(this.data);
        }
        this.parse();
    }

    public void write(ByteBuffer buffer) {
        this.update();
        buffer.putShort((short)this.id);
        buffer.putShort((short)this.data.length);
        buffer.put(this.data);
    }

    protected void parse() throws IOException {
    }

    protected void update() {
    }

    public int size() {
        return 4 + this.data.length;
    }

    public static Map<Integer, ExtraField> parseAll(ByteBuffer buffer, boolean uncompressedSize, boolean compressedSize, boolean localHeaderOffset, boolean diskNumberStart) throws IOException {
        LinkedHashMap<Integer, ExtraField> fields = new LinkedHashMap<Integer, ExtraField>();
        while (buffer.remaining() >= 4) {
            ExtraField field = new ExtraField();
            field.read(buffer);
            if (field.id == 1) {
                Zip64ExtendedInfoExtraField zip64 = new Zip64ExtendedInfoExtraField(uncompressedSize, compressedSize, localHeaderOffset, diskNumberStart);
                zip64.id = field.id;
                zip64.data = field.data;
                zip64.parse();
                fields.put(field.id, zip64);
                continue;
            }
            fields.put(field.id, field);
        }
        return fields;
    }
}

