/*
 * Decompiled with CFR 0.152.
 */
package net.jsign.timestamp;

import java.io.IOException;
import java.util.HashMap;
import net.jsign.DigestAlgorithm;
import net.jsign.asn1.authenticode.AuthenticodeObjectIdentifiers;
import net.jsign.timestamp.Timestamper;
import net.jsign.timestamp.TimestampingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;

public class RFC3161Timestamper
extends Timestamper {
    private boolean standardAttribute = false;

    public RFC3161Timestamper() {
        this.setURL("http://timestamp.sectigo.com");
    }

    @Override
    public CMSSignedData timestamp(DigestAlgorithm algo, CMSSignedData sigData) throws TimestampingException, IOException, CMSException {
        this.standardAttribute = !AuthenticodeObjectIdentifiers.isAuthenticode(sigData.getSignedContentTypeOID());
        return super.timestamp(algo, sigData);
    }

    @Override
    protected CMSSignedData timestamp(DigestAlgorithm algo, byte[] encryptedDigest) throws IOException, TimestampingException {
        TimeStampRequestGenerator reqgen = new TimeStampRequestGenerator();
        reqgen.setCertReq(true);
        TimeStampRequest req = reqgen.generate(algo.oid, algo.getMessageDigest().digest(encryptedDigest));
        byte[] request = req.getEncoded();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/timestamp-query");
        headers.put("Accept", "application/timestamp-reply");
        byte[] response = this.post(this.tsaurl, request, headers);
        try {
            TimeStampResponse resp = new TimeStampResponse(response);
            resp.validate(req);
            if (resp.getStatus() != 0) {
                throw new IOException("Unable to complete the timestamping due to an invalid response (" + resp.getStatusString() + ")");
            }
            return resp.getTimeStampToken().toCMSSignedData();
        }
        catch (Exception e) {
            throw new TimestampingException("Unable to complete the timestamping", e);
        }
    }

    @Override
    protected Attribute getCounterSignature(CMSSignedData token) {
        return new Attribute(this.standardAttribute ? PKCSObjectIdentifiers.id_aa_signatureTimeStampToken : AuthenticodeObjectIdentifiers.SPC_RFC3161_OBJID, (ASN1Set)new DERSet((ASN1Encodable)token.toASN1Structure()));
    }
}

