/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.recording;

import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import org.junit.platform.engine.UniqueId;

public class TestRun
implements Serializable {
    private final String uniqueIdString;
    private final int statusOrdinal;
    private final String randomSeed;
    private final List<Object> falsifiedSample;

    public TestRun(UniqueId uniqueId, PropertyExecutionResult.Status status, String randomSeed, List<Object> falsifiedSample) {
        this.uniqueIdString = uniqueId.toString();
        this.statusOrdinal = status.ordinal();
        this.randomSeed = randomSeed;
        this.falsifiedSample = falsifiedSample;
    }

    boolean hasUniqueId(UniqueId uniqueId) {
        return this.getUniqueId().equals((Object)uniqueId);
    }

    public boolean isNotSuccessful() {
        return this.getStatus() != PropertyExecutionResult.Status.SUCCESSFUL;
    }

    public UniqueId getUniqueId() {
        return UniqueId.parse((String)this.uniqueIdString);
    }

    public PropertyExecutionResult.Status getStatus() {
        return PropertyExecutionResult.Status.values()[this.statusOrdinal];
    }

    public Optional<String> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    public Optional<List<Object>> falsifiedSample() {
        return Optional.ofNullable(this.falsifiedSample);
    }

    public String toString() {
        String randomSeedString = this.randomSeed().map(s -> ":" + s).orElse("");
        return String.format("TestRun[%s:%s%s]", this.uniqueIdString, this.getStatus(), randomSeedString);
    }

    TestRun withoutFalsifiedSample() {
        return new TestRun(this.getUniqueId(), this.getStatus(), this.randomSeed, null);
    }
}

