/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.shrinking.ShrinkableContainer;

public class ShrinkableString
extends ShrinkableContainer<String, Character> {
    private final int minSize;

    public ShrinkableString(List<Shrinkable<Character>> elements, int minSize) {
        super(elements, minSize);
        this.minSize = minSize;
    }

    @Override
    Collector<Character, ?, String> containerCollector() {
        return new CharacterCollector();
    }

    @Override
    Shrinkable<String> createShrinkable(List<Shrinkable<Character>> shrunkElements) {
        return new ShrinkableString(shrunkElements, this.minSize);
    }

    private static class CharacterCollector
    implements Collector<Character, StringBuilder, String> {
        private CharacterCollector() {
        }

        @Override
        public Supplier<StringBuilder> supplier() {
            return StringBuilder::new;
        }

        @Override
        public BiConsumer<StringBuilder, Character> accumulator() {
            return StringBuilder::appendCodePoint;
        }

        @Override
        public BinaryOperator<StringBuilder> combiner() {
            return StringBuilder::append;
        }

        @Override
        public Function<StringBuilder, String> finisher() {
            return StringBuilder::toString;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Collections.emptySet();
        }
    }
}

