/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.math.BigInteger;
import java.util.Set;
import java.util.stream.Collectors;
import net.jqwik.api.JqwikException;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.engine.properties.Range;
import net.jqwik.engine.properties.shrinking.AbstractShrinkable;
import net.jqwik.engine.properties.shrinking.BigIntegerShrinkingCandidates;

public class ShrinkableBigInteger
extends AbstractShrinkable<BigInteger> {
    private final Range<BigInteger> range;
    private final BigInteger shrinkingTarget;
    private final BigIntegerShrinkingCandidates shrinkingCandidates;

    public static BigInteger defaultShrinkingTarget(BigInteger value, Range<BigInteger> range) {
        if (range.includes(BigInteger.ZERO)) {
            return BigInteger.ZERO;
        }
        if (value.compareTo(BigInteger.ZERO) < 0) {
            return (BigInteger)range.max;
        }
        if (value.compareTo(BigInteger.ZERO) > 0) {
            return (BigInteger)range.min;
        }
        return value;
    }

    public ShrinkableBigInteger(BigInteger value, Range<BigInteger> range, BigInteger shrinkingTarget) {
        super(value);
        this.range = range;
        this.shrinkingTarget = shrinkingTarget;
        this.shrinkingCandidates = new BigIntegerShrinkingCandidates(this.shrinkingTarget);
        this.checkTargetInRange(shrinkingTarget);
        this.checkValueInRange(value);
    }

    @Override
    public Set<Shrinkable<BigInteger>> shrinkCandidatesFor(Shrinkable<BigInteger> shrinkable) {
        return this.shrinkingCandidates.candidatesFor((BigInteger)shrinkable.value()).stream().map(aBigInteger -> new ShrinkableBigInteger((BigInteger)aBigInteger, this.range, this.shrinkingTarget)).collect(Collectors.toSet());
    }

    public ShrinkingDistance distance() {
        return ShrinkableBigInteger.distanceFor((BigInteger)this.value(), this.shrinkingTarget);
    }

    static ShrinkingDistance distanceFor(BigInteger value, BigInteger target) {
        BigInteger distance = value.subtract(target).abs();
        if (distance.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) >= 0) {
            return ShrinkingDistance.of((long[])new long[]{Long.MAX_VALUE});
        }
        return ShrinkingDistance.of((long[])new long[]{distance.longValueExact()});
    }

    private void checkTargetInRange(BigInteger value) {
        if (!this.range.includes(value)) {
            String message = String.format("Shrinking target <%s> is outside allowed range %s", value, this.range);
            throw new JqwikException(message);
        }
    }

    private void checkValueInRange(BigInteger value) {
        if (!this.range.includes(value)) {
            String message = String.format("Value <%s> is outside allowed range %s", value, this.range);
            throw new JqwikException(message);
        }
    }
}

