/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.shrinking;

import java.util.function.Consumer;
import java.util.function.Function;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingSequence;

public class NextShrinkingSequence<T>
implements ShrinkingSequence<T> {
    private final ShrinkingSequence<T> before;
    private final Function<Shrinkable<T>, ShrinkingSequence<T>> nextShrinkingStep;
    private ShrinkingSequence<T> nextSequence = null;
    private FalsificationResult<T> current = null;

    public NextShrinkingSequence(ShrinkingSequence<T> before, Function<Shrinkable<T>, ShrinkingSequence<T>> nextShrinkingStep) {
        this.before = before;
        this.nextShrinkingStep = nextShrinkingStep;
        this.current = before.current();
    }

    public void init(FalsificationResult<T> initialCurrent) {
        this.current = this.current == null ? initialCurrent : FalsificationResult.falsified((Shrinkable)this.current.shrinkable(), (Throwable)initialCurrent.throwable().orElse(null));
        this.before.init(initialCurrent);
    }

    public boolean next(Runnable count, Consumer<FalsificationResult<T>> falsifiedReporter) {
        boolean next;
        if (this.nextSequence == null) {
            if (this.before.next(count, falsifiedReporter)) {
                this.current = this.before.current();
                return true;
            }
            this.nextSequence = this.nextShrinkingStep.apply(this.current.shrinkable());
            this.nextSequence.init(this.current);
        }
        if (next = this.nextSequence.next(count, falsifiedReporter)) {
            this.current = this.nextSequence.current();
        }
        return next;
    }

    public FalsificationResult<T> current() {
        return this.current;
    }

    public String toString() {
        return String.format("Next [%s, %s]", this.before, this.nextSequence);
    }
}

