/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.engine.properties.arbitraries.DefaultCollectionArbitrary;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;

public class StreamArbitrary<T>
extends DefaultCollectionArbitrary<T, Stream<T>> {
    public StreamArbitrary(Arbitrary<T> elementArbitrary) {
        super(elementArbitrary);
    }

    @Override
    protected Iterable<T> toIterable(Stream<T> streamable) {
        return streamable::iterator;
    }

    public RandomGenerator<Stream<T>> generator(int genSize) {
        return this.createListGenerator(genSize).map(Collection::stream);
    }

    public Optional<ExhaustiveGenerator<Stream<T>>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.list(this.elementArbitrary, this.minSize, this.maxSize, maxNumberOfSamples).map(generator -> generator.map(Collection::stream));
    }
}

