/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Tuple;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.configurators.SelfConfiguringArbitrary;
import net.jqwik.api.providers.TypeUsage;

public class LazyArbitrary<T>
implements Arbitrary<T>,
SelfConfiguringArbitrary<T> {
    private final Supplier<Arbitrary<T>> arbitrarySupplier;
    private List<Tuple.Tuple2<ArbitraryConfigurator, TypeUsage>> configurations = new ArrayList<Tuple.Tuple2<ArbitraryConfigurator, TypeUsage>>();

    public LazyArbitrary(Supplier<Arbitrary<T>> arbitrarySupplier) {
        this.arbitrarySupplier = arbitrarySupplier;
    }

    public RandomGenerator<T> generator(int genSize) {
        Arbitrary arbitrary = this.arbitrarySupplier.get();
        for (Tuple.Tuple2<ArbitraryConfigurator, TypeUsage> configuration : this.configurations) {
            ArbitraryConfigurator configurator = (ArbitraryConfigurator)configuration.get1();
            TypeUsage targetType = (TypeUsage)configuration.get2();
            if (arbitrary instanceof SelfConfiguringArbitrary) {
                arbitrary = ((SelfConfiguringArbitrary)arbitrary).configure(configurator, targetType);
                continue;
            }
            arbitrary = configurator.configure(arbitrary, targetType);
        }
        return arbitrary.generator(genSize);
    }

    public Arbitrary<T> configure(ArbitraryConfigurator configurator, TypeUsage targetType) {
        this.configurations.add((Tuple.Tuple2<ArbitraryConfigurator, TypeUsage>)Tuple.of((Object)configurator, (Object)targetType));
        return this;
    }
}

