/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Optional;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.JqwikException;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.engine.properties.arbitraries.GenerationError;

class IgnoreGenerationErrorArbitrary<T>
implements Arbitrary<T> {
    private Arbitrary<T> arbitrary;

    IgnoreGenerationErrorArbitrary(Arbitrary<T> arbitrary) {
        this.arbitrary = arbitrary;
    }

    public RandomGenerator<T> generator(int genSize) {
        RandomGenerator generator = this.arbitrary.generator(genSize);
        return random -> {
            int count = 0;
            while (count++ < 1000) {
                try {
                    Shrinkable next = generator.next(random);
                    return next;
                }
                catch (GenerationError next) {
                }
            }
            String message = String.format("Too many exceptions while generating values with %s", this.arbitrary.toString());
            throw new JqwikException(message);
        };
    }

    public Optional<ExhaustiveGenerator<T>> exhaustive(long maxNumberOfSamples) {
        return Optional.empty();
    }
}

