/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.arbitraries.CharacterArbitrary;
import net.jqwik.api.arbitraries.StringArbitrary;
import net.jqwik.engine.properties.arbitraries.AbstractArbitraryBase;
import net.jqwik.engine.properties.arbitraries.DefaultCharacterArbitrary;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;
import net.jqwik.engine.properties.arbitraries.randomized.RandomGenerators;

public class DefaultStringArbitrary
extends AbstractArbitraryBase
implements StringArbitrary {
    private CharacterArbitrary characterArbitrary = new DefaultCharacterArbitrary();
    private int minLength = 0;
    private int maxLength = 255;

    public RandomGenerator<String> generator(int genSize) {
        int cutoffLength = RandomGenerators.defaultCutoffSize(this.minLength, this.maxLength, genSize);
        List samples = Arrays.stream(new String[]{""}).filter(s -> s.length() >= this.minLength && s.length() <= this.maxLength).map(Shrinkable::unshrinkable).collect(Collectors.toList());
        return RandomGenerators.strings(this.randomCharacterGenerator(), this.minLength, this.maxLength, cutoffLength).withEdgeCases(genSize, samples);
    }

    public Optional<ExhaustiveGenerator<String>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.strings(this.effectiveCharacterArbitrary(), this.minLength, this.maxLength, maxNumberOfSamples);
    }

    public StringArbitrary ofMinLength(int minLength) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.minLength = minLength;
        return clone;
    }

    public StringArbitrary ofMaxLength(int maxLength) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.maxLength = maxLength;
        return clone;
    }

    public StringArbitrary withChars(char ... chars) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.with(chars);
        return clone;
    }

    public StringArbitrary withChars(CharSequence chars) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.with(chars);
        return clone;
    }

    public StringArbitrary withCharRange(char from, char to) {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.range(from, to);
        return clone;
    }

    public StringArbitrary ascii() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = this.characterArbitrary.ascii();
        return clone;
    }

    public StringArbitrary alpha() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.range('A', 'Z').range('a', 'z');
        return clone;
    }

    public StringArbitrary numeric() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.range('0', '9');
        return clone;
    }

    public StringArbitrary whitespace() {
        DefaultStringArbitrary clone = (DefaultStringArbitrary)this.typedClone();
        clone.characterArbitrary = clone.characterArbitrary.whitespace();
        return clone;
    }

    public StringArbitrary all() {
        return this.withCharRange('\u0000', '\uffff');
    }

    private RandomGenerator<Character> randomCharacterGenerator() {
        return this.effectiveCharacterArbitrary().generator(1);
    }

    private Arbitrary<Character> effectiveCharacterArbitrary() {
        return this.characterArbitrary;
    }
}

