/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.properties.arbitraries;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.ExhaustiveGenerator;
import net.jqwik.api.RandomGenerator;
import net.jqwik.api.arbitraries.StreamableArbitrary;
import net.jqwik.api.configurators.ArbitraryConfigurator;
import net.jqwik.api.configurators.SelfConfiguringArbitrary;
import net.jqwik.api.providers.TypeUsage;
import net.jqwik.engine.properties.arbitraries.MultivalueArbitraryBase;
import net.jqwik.engine.properties.arbitraries.exhaustive.ExhaustiveGenerators;

public class ArrayArbitrary<A, T>
extends MultivalueArbitraryBase<T>
implements StreamableArbitrary<T, A>,
SelfConfiguringArbitrary<A> {
    private final Class<A> arrayClass;

    public ArrayArbitrary(Arbitrary<T> elementArbitrary, Class<A> arrayClass) {
        super(elementArbitrary);
        this.arrayClass = arrayClass;
    }

    public RandomGenerator<A> generator(int genSize) {
        return this.createListGenerator(genSize).map(this::toArray);
    }

    public Optional<ExhaustiveGenerator<A>> exhaustive(long maxNumberOfSamples) {
        return ExhaustiveGenerators.list(this.elementArbitrary, this.minSize, this.maxSize, maxNumberOfSamples).map(generator -> generator.map(this::toArray));
    }

    private A toArray(List<T> from) {
        Object array = Array.newInstance(this.arrayClass.getComponentType(), from.size());
        for (int i = 0; i < from.size(); ++i) {
            Array.set(array, i, from.get(i));
        }
        return (A)array;
    }

    public <R> Arbitrary<R> reduce(R initial, BiFunction<R, T, R> accumulator) {
        return this.map(streamable -> {
            Object[] array;
            Object[] result = new Object[]{initial};
            for (Object each : array = (Object[])streamable) {
                result[0] = accumulator.apply(result[0], each);
            }
            return result[0];
        });
    }

    public StreamableArbitrary<T, A> ofMinSize(int minSize) {
        ArrayArbitrary clone = (ArrayArbitrary)this.typedClone();
        clone.minSize = minSize;
        return clone;
    }

    public StreamableArbitrary<T, A> ofMaxSize(int maxSize) {
        ArrayArbitrary clone = (ArrayArbitrary)this.typedClone();
        clone.maxSize = maxSize;
        return clone;
    }

    public Arbitrary<A> configure(ArbitraryConfigurator configurator, TypeUsage targetType) {
        this.elementArbitrary = configurator.configure(this.elementArbitrary, targetType);
        return configurator.configure((Arbitrary)this, targetType);
    }
}

