/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution.lifecycle;

import java.util.List;
import java.util.Optional;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.engine.execution.lifecycle.ExtendedPropertyExecutionResult;

public class PlainExecutionResult
implements ExtendedPropertyExecutionResult {
    private final PropertyExecutionResult.Status status;
    private final String seed;
    private final Throwable throwable;

    public static ExtendedPropertyExecutionResult successful() {
        return new PlainExecutionResult(PropertyExecutionResult.Status.SUCCESSFUL, null, null);
    }

    private static ExtendedPropertyExecutionResult successful(String seed) {
        return new PlainExecutionResult(PropertyExecutionResult.Status.SUCCESSFUL, seed, null);
    }

    public static ExtendedPropertyExecutionResult failed(Throwable throwable, String seed) {
        if (throwable == null) {
            throw new IllegalArgumentException("throwable must never be null for failed PropertyExecutionResult");
        }
        return new PlainExecutionResult(PropertyExecutionResult.Status.FAILED, seed, throwable);
    }

    public static ExtendedPropertyExecutionResult aborted(Throwable throwable, String seed) {
        if (throwable == null) {
            throw new IllegalArgumentException("throwable must never be null for aborted PropertyExecutionResult");
        }
        return new PlainExecutionResult(PropertyExecutionResult.Status.ABORTED, seed, throwable);
    }

    private PlainExecutionResult(PropertyExecutionResult.Status status, String seed, Throwable throwable) {
        this.status = status;
        this.seed = seed != null ? (seed.isEmpty() ? null : seed) : null;
        this.throwable = throwable;
    }

    public Optional<String> seed() {
        return Optional.ofNullable(this.seed);
    }

    public Optional<List<Object>> falsifiedSample() {
        return Optional.empty();
    }

    public PropertyExecutionResult.Status status() {
        return this.status;
    }

    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    public PropertyExecutionResult mapTo(PropertyExecutionResult.Status newStatus, Throwable throwable) {
        return new PlainExecutionResult(newStatus, this.seed, throwable);
    }

    @Override
    public boolean isExtended() {
        return false;
    }

    public int countChecks() {
        return 0;
    }

    public int countTries() {
        return 0;
    }

    @Override
    public Optional<List<Object>> originalSample() {
        return Optional.empty();
    }

    @Override
    public GenerationMode generation() {
        return GenerationMode.NOT_SET;
    }

    @Override
    public String randomSeed() {
        return Long.toString(0L);
    }

    public String toString() {
        return String.format("PlainPropertyExecutionResult[%s]", this.status);
    }
}

