/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.Optional;
import net.jqwik.api.Falsifier;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.api.lifecycle.CannotResolveParameterException;
import net.jqwik.api.lifecycle.ParameterResolutionContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.TryLifecycleContext;

public class ShrinkableResolvedParameter
implements Shrinkable<Object> {
    private final ResolveParameterHook.ParameterSupplier supplier;
    private final ParameterResolutionContext context;
    private final TryLifecycleContext tryLifecycleContext;

    public ShrinkableResolvedParameter(ResolveParameterHook.ParameterSupplier supplier, ParameterResolutionContext context, TryLifecycleContext tryLifecycleContext) {
        this.supplier = supplier;
        this.context = context;
        this.tryLifecycleContext = tryLifecycleContext;
    }

    public Object value() {
        Optional<TryLifecycleContext> optionalTry = Optional.of(this.tryLifecycleContext);
        Object value = this.supplier.get(optionalTry);
        if (!this.context.typeUsage().isAssignableFrom(value.getClass())) {
            String info = String.format("Type [%s] of resolved value does not fit parameter type [%s]", value.getClass().getName(), this.context.parameter().getParameterizedType().getTypeName());
            throw new CannotResolveParameterException(this.context, info);
        }
        return value;
    }

    public ShrinkingSequence<Object> shrink(Falsifier<Object> falsifier) {
        return ShrinkingSequence.dontShrink((Shrinkable)this);
    }

    public ShrinkingDistance distance() {
        return ShrinkingDistance.of((long[])new long[]{0L});
    }

    public String toString() {
        return String.format("Unshrinkable resolved parameter for [%s]", this.context.parameter());
    }
}

