/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.jqwik.api.AfterFailureMode;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.engine.execution.lifecycle.ExtendedPropertyExecutionResult;
import net.jqwik.engine.support.JqwikStringSupport;
import org.junit.platform.engine.reporting.ReportEntry;
import org.opentest4j.AssertionFailedError;

public class ExecutionResultReportEntry {
    private static final String TRIES_KEY = "tries";
    private static final String CHECKS_KEY = "checks";
    private static final String GENERATION_KEY = "generation-mode";
    private static final String AFTER_FAILURE_KEY = "after-failure";
    private static final String SEED_KEY = "seed";
    private static final String SAMPLE_KEY = "sample";
    private static final String ORIGINAL_SAMPLE_KEY = "original-sample";

    public static ReportEntry from(String propertyName, ExtendedPropertyExecutionResult executionResult, AfterFailureMode afterFailureMode) {
        return ExecutionResultReportEntry.buildJqwikReport(propertyName, executionResult, afterFailureMode);
    }

    private static ReportEntry buildJqwikReport(String propertyName, ExtendedPropertyExecutionResult executionResult, AfterFailureMode afterFailureMode) {
        StringBuilder reportLines = new StringBuilder();
        ExecutionResultReportEntry.appendThrowableMessage(reportLines, executionResult);
        ExecutionResultReportEntry.appendFixedSizedProperties(reportLines, executionResult, afterFailureMode);
        ExecutionResultReportEntry.appendSamples(reportLines, executionResult);
        return ReportEntry.from((String)propertyName, (String)reportLines.toString());
    }

    private static void appendSamples(StringBuilder reportLines, ExtendedPropertyExecutionResult executionResult) {
        executionResult.falsifiedSample().ifPresent(shrunkSample -> {
            if (!shrunkSample.isEmpty()) {
                reportLines.append(String.format("%s%n", ExecutionResultReportEntry.buildProperty(SAMPLE_KEY, JqwikStringSupport.displayString(shrunkSample))));
            }
        });
        if (executionResult.isExtended()) {
            executionResult.originalSample().ifPresent(originalSample -> {
                if (!originalSample.isEmpty()) {
                    reportLines.append(String.format("%s%n", ExecutionResultReportEntry.buildProperty(ORIGINAL_SAMPLE_KEY, JqwikStringSupport.displayString(originalSample))));
                }
            });
        }
    }

    private static void appendFixedSizedProperties(StringBuilder reportLines, ExtendedPropertyExecutionResult executionResult, AfterFailureMode afterFailureMode) {
        ArrayList<String> propertiesLines = new ArrayList<String>();
        int countTries = 0;
        int countChecks = 0;
        String generationMode = "<none>";
        String randomSeed = "<none>";
        String helpGenerationMode = "";
        if (executionResult.isExtended()) {
            countTries = executionResult.countTries();
            countChecks = executionResult.countChecks();
            generationMode = executionResult.generation().name();
            randomSeed = executionResult.randomSeed();
            helpGenerationMode = ExecutionResultReportEntry.helpGenerationMode(executionResult.generation());
        }
        ExecutionResultReportEntry.appendProperty(propertiesLines, TRIES_KEY, Integer.toString(countTries), "# of calls to property");
        ExecutionResultReportEntry.appendProperty(propertiesLines, CHECKS_KEY, Integer.toString(countChecks), "# of not rejected calls");
        ExecutionResultReportEntry.appendProperty(propertiesLines, GENERATION_KEY, generationMode, helpGenerationMode);
        if (afterFailureMode != AfterFailureMode.NOT_SET) {
            ExecutionResultReportEntry.appendProperty(propertiesLines, AFTER_FAILURE_KEY, afterFailureMode.name(), ExecutionResultReportEntry.helpAfterFailureMode(afterFailureMode));
        }
        ExecutionResultReportEntry.appendProperty(propertiesLines, SEED_KEY, randomSeed, "random seed to reproduce generated values");
        int halfBorderLength = (propertiesLines.stream().mapToInt(String::length).max().orElse(50) - 37) / 2 + 1;
        String halfBorder = String.join((CharSequence)"", Collections.nCopies(halfBorderLength, "-"));
        reportLines.append(String.format("%n", new Object[0]));
        reportLines.append(ExecutionResultReportEntry.buildLine("", "|" + halfBorder + "jqwik" + halfBorder));
        propertiesLines.forEach(reportLines::append);
    }

    private static void appendThrowableMessage(StringBuilder reportLines, ExtendedPropertyExecutionResult executionResult) {
        if (executionResult.status() != PropertyExecutionResult.Status.SUCCESSFUL) {
            Throwable throwable = (Throwable)executionResult.throwable().orElse(new AssertionFailedError(null));
            String assertionClass = throwable.getClass().getName();
            String assertionMessage = throwable.getMessage();
            reportLines.append(String.format("%n%n%s: ", assertionClass));
            reportLines.append(String.format("%s%n", assertionMessage));
        }
    }

    private static String helpAfterFailureMode(AfterFailureMode afterFailureMode) {
        switch (afterFailureMode) {
            case RANDOM_SEED: {
                return "use a new random seed";
            }
            case PREVIOUS_SEED: {
                return "use the previous seed";
            }
            case SAMPLE_ONLY: {
                return "only try the previously failed sample";
            }
            case SAMPLE_FIRST: {
                return "try previously failed sample, then previous seed";
            }
        }
        return "RANDOM_SEED, PREVIOUS_SEED or SAMPLE_FIRST";
    }

    private static String helpGenerationMode(GenerationMode generation) {
        switch (generation) {
            case RANDOMIZED: {
                return "parameters are randomly generated";
            }
            case EXHAUSTIVE: {
                return "parameters are exhaustively generated";
            }
            case DATA_DRIVEN: {
                return "parameters are taken from data provider";
            }
        }
        return "RANDOMIZED, EXHAUSTIVE or DATA_DRIVEN";
    }

    private static void appendProperty(List<String> propertiesLines, String triesKey, String value, String comment) {
        propertiesLines.add(ExecutionResultReportEntry.buildPropertyLine(triesKey, value, comment));
    }

    private static String buildPropertyLine(String key, String value, String help) {
        return ExecutionResultReportEntry.buildLine(ExecutionResultReportEntry.buildProperty(key, value), String.format("| %s", help));
    }

    private static String buildProperty(String key, String value) {
        return String.format("%s = %s", key, value);
    }

    private static String buildLine(String body, String helpString) {
        return String.format("%-30s%s%n", body, helpString);
    }
}

