/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.util.Set;
import java.util.function.Predicate;
import net.jqwik.api.domains.Domain;
import net.jqwik.engine.descriptor.DiscoverySupport;
import net.jqwik.engine.descriptor.JqwikDescriptor;
import net.jqwik.engine.discovery.predicates.IsContainerAGroup;
import net.jqwik.engine.discovery.predicates.IsTopLevelClass;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;

public class ContainerClassDescriptor
extends AbstractTestDescriptor
implements JqwikDescriptor {
    private static final Predicate<Class<?>> isTopLevelClass = new IsTopLevelClass();
    private static final Predicate<Class<?>> isContainerAGroup = new IsContainerAGroup();
    private final Class<?> containerClass;
    private final boolean isGroup;
    private final Set<TestTag> tags;
    private final Set<Domain> domains;

    public ContainerClassDescriptor(UniqueId uniqueId, Class<?> containerClass, boolean isGroup) {
        super(uniqueId, ContainerClassDescriptor.determineDisplayName(containerClass), (TestSource)ClassSource.from(containerClass));
        this.tags = DiscoverySupport.findTestTags(containerClass);
        this.domains = DiscoverySupport.findDomains(containerClass);
        this.containerClass = containerClass;
        this.isGroup = isGroup;
    }

    private static String determineDisplayName(Class<?> containerClass) {
        return DiscoverySupport.determineLabel(containerClass, () -> ContainerClassDescriptor.getDefaultDisplayName(containerClass));
    }

    private static String getDefaultDisplayName(Class<?> containerClass) {
        if (isTopLevelClass.test(containerClass) || isContainerAGroup.test(containerClass)) {
            return containerClass.getSimpleName();
        }
        return ContainerClassDescriptor.getCanonicalNameWithoutPackage(containerClass);
    }

    private static String getCanonicalNameWithoutPackage(Class<?> containerClass) {
        String packageName = containerClass.getPackage().getName();
        String canonicalName = containerClass.getCanonicalName();
        return canonicalName.substring(packageName.length() + 1);
    }

    public Set<TestTag> getTags() {
        return DiscoverySupport.getTags(this.getParent(), this.tags);
    }

    @Override
    public Set<Domain> getDomains() {
        return DiscoverySupport.getDomains(this.getJqwikParent(), this.domains);
    }

    @Override
    public AnnotatedElement getAnnotatedElement() {
        return this.getContainerClass();
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public Class<?> getContainerClass() {
        return this.containerClass;
    }

    public boolean isGroup() {
        return this.isGroup;
    }
}

