/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import net.javacrumbs.jsonunit.core.internal.AbstractNode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Utils;
import org.jspecify.annotations.Nullable;

class GsonNodeFactory
extends AbstractNodeFactory {
    private final Gson gson = new Gson();

    GsonNodeFactory() {
    }

    @Override
    protected Node doConvertValue(Object source) {
        if (source instanceof JsonElement) {
            JsonElement jsonElement = (JsonElement)source;
            return GsonNodeFactory.newNode(jsonElement);
        }
        return GsonNodeFactory.newNode(this.gson.toJsonTree(source));
    }

    @Override
    protected Node nullNode() {
        return GsonNodeFactory.newNode((JsonElement)JsonNull.INSTANCE);
    }

    @Override
    protected Node readValue(Reader value, String label, boolean lenient) {
        try {
            Node node = GsonNodeFactory.newNode(JsonParser.parseReader((Reader)value));
            return node;
        }
        catch (JsonIOException | JsonSyntaxException e) {
            throw this.newParseException(label, value, (Exception)e);
        }
        finally {
            Utils.closeQuietly(value);
        }
    }

    private static Node newNode(@Nullable JsonElement jsonNode) {
        if (jsonNode != null) {
            return new GsonNode(jsonNode);
        }
        return Node.MISSING_NODE;
    }

    @Override
    public boolean isPreferredFor(@Nullable Object source) {
        return source instanceof JsonElement;
    }

    static final class GsonNode
    extends AbstractNode {
        private final JsonElement jsonNode;

        GsonNode(JsonElement jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public Node element(int index) {
            JsonElement jsonElement = this.jsonNode;
            if (jsonElement instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonElement;
                try {
                    return GsonNodeFactory.newNode(jsonArray.get(index));
                }
                catch (IndexOutOfBoundsException e) {
                    return MISSING_NODE;
                }
            }
            return MISSING_NODE;
        }

        @Override
        public Iterator<Node.KeyValue> fields() {
            if (this.isObject()) {
                final Iterator iterator = ((JsonObject)this.jsonNode).entrySet().iterator();
                return new Iterator<Node.KeyValue>(this){
                    final /* synthetic */ GsonNode this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Node.KeyValue next() {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        return new Node.KeyValue((String)entry.getKey(), GsonNodeFactory.newNode((JsonElement)entry.getValue()));
                    }
                };
            }
            throw new IllegalStateException("Can call fields() only on an JsonObject");
        }

        @Override
        public Node get(String key) {
            JsonElement jsonElement = this.jsonNode;
            if (jsonElement instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)jsonElement;
                return GsonNodeFactory.newNode(jsonObject.get(key));
            }
            return Node.MISSING_NODE;
        }

        @Override
        public boolean isMissingNode() {
            return false;
        }

        @Override
        public boolean isNull() {
            return this.jsonNode.isJsonNull();
        }

        @Override
        public boolean isObject() {
            return this.jsonNode instanceof JsonObject;
        }

        @Override
        public Iterator<Node> arrayElements() {
            JsonElement jsonElement = this.jsonNode;
            if (jsonElement instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonElement;
                final Iterator iterator = jsonArray.iterator();
                return new Iterator<Node>(this){
                    final /* synthetic */ GsonNode this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Node next() {
                        JsonElement entry = (JsonElement)iterator.next();
                        return GsonNodeFactory.newNode(entry);
                    }
                };
            }
            throw new IllegalStateException("Can call arrayElements() only on an JsonArray");
        }

        @Override
        public int size() {
            JsonElement jsonElement = this.jsonNode;
            if (jsonElement instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonElement;
                return jsonArray.size();
            }
            throw new IllegalStateException("Can call arrayElements() only on an JsonArray");
        }

        @Override
        public String asText() {
            return this.jsonNode.getAsString();
        }

        @Override
        public Node.NodeType getNodeType() {
            JsonPrimitive jsonPrimitive;
            JsonPrimitive jsonPrimitive2;
            JsonPrimitive jsonPrimitive3;
            if (this.jsonNode.isJsonObject()) {
                return Node.NodeType.OBJECT;
            }
            if (this.jsonNode.isJsonArray()) {
                return Node.NodeType.ARRAY;
            }
            JsonElement jsonElement = this.jsonNode;
            if (jsonElement instanceof JsonPrimitive && (jsonPrimitive3 = (JsonPrimitive)jsonElement).isString()) {
                return Node.NodeType.STRING;
            }
            jsonElement = this.jsonNode;
            if (jsonElement instanceof JsonPrimitive && (jsonPrimitive2 = (JsonPrimitive)jsonElement).isNumber()) {
                return Node.NodeType.NUMBER;
            }
            jsonElement = this.jsonNode;
            if (jsonElement instanceof JsonPrimitive && (jsonPrimitive = (JsonPrimitive)jsonElement).isBoolean()) {
                return Node.NodeType.BOOLEAN;
            }
            if (this.jsonNode.isJsonNull()) {
                return Node.NodeType.NULL;
            }
            throw new IllegalStateException("Unexpected node type " + String.valueOf(this.jsonNode));
        }

        @Override
        public BigDecimal decimalValue() {
            return this.jsonNode.getAsBigDecimal();
        }

        @Override
        public boolean isIntegralNumber() {
            String string = this.jsonNode.getAsString();
            return this.jsonNode.getAsBigDecimal().scale() == 0 && !string.contains("e") && !string.contains("E");
        }

        @Override
        public Boolean asBoolean() {
            return this.jsonNode.getAsBoolean();
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

