/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import net.javacrumbs.jsonunit.core.internal.Context;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.Path;
import net.javacrumbs.jsonunit.core.listener.Difference;
import org.jspecify.annotations.Nullable;

class DifferenceImpl
implements Difference {
    private final DiffContext context;
    private final Difference.Type type;

    DifferenceImpl(DiffContext context, Difference.Type type) {
        this.context = context;
        this.type = type;
    }

    @Override
    public @Nullable String getActualPath() {
        return this.context.actualPath() != null ? this.context.actualPath().getFullPath() : null;
    }

    @Override
    public @Nullable String getExpectedPath() {
        return this.context.expectedPath() != null ? this.context.expectedPath().getFullPath() : null;
    }

    @Override
    public @Nullable Object getActual() {
        Node actualNode = this.context.actualNode();
        return actualNode != null && !actualNode.isMissingNode() ? actualNode.getValue() : null;
    }

    @Override
    public @Nullable Object getExpected() {
        Node expectedNode = this.context.expectedNode();
        return expectedNode != null && !expectedNode.isMissingNode() ? expectedNode.getValue() : null;
    }

    public String toString() {
        return String.valueOf((Object)this.getType()) + " Expected " + String.valueOf(this.getExpected()) + " in " + this.getExpectedPath() + " got " + String.valueOf(this.getActual()) + " in " + this.getActualPath();
    }

    @Override
    public Difference.Type getType() {
        return this.type;
    }

    static Difference missing(Context context) {
        return new MissingDifference(DiffContext.from(context).clearActual());
    }

    static Difference extra(Context context) {
        return new ExtraDifference(DiffContext.from(context).clearExpected());
    }

    static Difference different(Context context) {
        return new DifferenceImpl(DiffContext.from(context), Difference.Type.DIFFERENT);
    }

    private record DiffContext(@Nullable Node expectedNode, @Nullable Node actualNode, @Nullable Path expectedPath, @Nullable Path actualPath) {
        private static DiffContext from(Context context) {
            return new DiffContext(context.expectedNode(), context.actualNode(), context.expectedPath(), context.actualPath());
        }

        private DiffContext clearActual() {
            return new DiffContext(this.expectedNode, null, this.expectedPath, null);
        }

        private DiffContext clearExpected() {
            return new DiffContext(null, this.actualNode, null, this.actualPath);
        }
    }

    private static class MissingDifference
    extends DifferenceImpl {
        MissingDifference(DiffContext context) {
            super(context, Difference.Type.MISSING);
        }

        @Override
        public String toString() {
            return String.valueOf((Object)this.getType()) + " " + String.valueOf(this.getExpected()) + " in " + this.getExpectedPath();
        }
    }

    private static class ExtraDifference
    extends DifferenceImpl {
        ExtraDifference(DiffContext context) {
            super(context, Difference.Type.EXTRA);
        }

        @Override
        public String toString() {
            return String.valueOf((Object)this.getType()) + " " + String.valueOf(this.getActual()) + " in " + this.getActualPath();
        }
    }
}

