/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import java.io.Reader;
import java.math.BigDecimal;
import net.javacrumbs.jsonunit.core.internal.GenericNodeBuilder;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.NodeFactory;
import net.javacrumbs.jsonunit.core.internal.Utils;
import org.jetbrains.annotations.NotNull;

abstract class AbstractNodeFactory
implements NodeFactory {
    AbstractNodeFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node convertToNode(Object source, String label, boolean lenient) {
        if (source == null) {
            return this.nullNode();
        }
        if (source instanceof Node) {
            return (Node)source;
        }
        if (source instanceof String && !((String)source).trim().isEmpty()) {
            return this.readValue((String)source, label, lenient);
        }
        if (source instanceof Reader) {
            try {
                Node node = this.readValue((Reader)source, label, lenient);
                return node;
            }
            finally {
                Utils.closeQuietly((Reader)source);
            }
        }
        return this.convertValue(source);
    }

    final Node convertValue(Object source) {
        if (source instanceof BigDecimal) {
            return new GenericNodeBuilder.NumberNode((Number)source);
        }
        return this.doConvertValue(source);
    }

    @NotNull
    protected IllegalArgumentException newParseException(String label, Reader value, Exception e) {
        if (value instanceof Utils.JsonStringReader) {
            return new IllegalArgumentException("Can not parse " + label + " value: '" + ((Utils.JsonStringReader)value).getString() + "'", e);
        }
        return new IllegalArgumentException("Can not parse " + label + " value.", e);
    }

    protected abstract Node doConvertValue(Object var1);

    protected abstract Node readValue(Reader var1, String var2, boolean var3);

    Node readValue(String source, String label, boolean lenient) {
        return this.readValue(Utils.toReader(source), label, lenient);
    }

    protected abstract Node nullNode();
}

