/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque.admin;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.greghaines.jesque.Config;
import net.greghaines.jesque.admin.AbstractAdminClient;
import net.greghaines.jesque.utils.JedisUtils;
import redis.clients.jedis.Jedis;

public class AdminClientImpl
extends AbstractAdminClient {
    public static final boolean DEFAULT_CHECK_CONNECTION_BEFORE_USE = false;
    private final Config config;
    private final Jedis jedis;
    private final boolean checkConnectionBeforeUse;
    private final ScheduledExecutorService keepAliveService;

    public AdminClientImpl(Config config) {
        this(config, false);
    }

    public AdminClientImpl(Config config, boolean checkConnectionBeforeUse) {
        super(config);
        this.config = config;
        this.jedis = new Jedis(config.getHost(), config.getPort(), config.getTimeout());
        this.authenticateAndSelectDB();
        this.checkConnectionBeforeUse = checkConnectionBeforeUse;
        this.keepAliveService = null;
    }

    public AdminClientImpl(Config config, long initialDelay, long period, TimeUnit timeUnit) {
        super(config);
        this.config = config;
        this.jedis = new Jedis(config.getHost(), config.getPort(), config.getTimeout());
        this.authenticateAndSelectDB();
        this.checkConnectionBeforeUse = false;
        this.keepAliveService = Executors.newSingleThreadScheduledExecutor();
        this.keepAliveService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                AdminClientImpl.this.ensureJedisConnection();
            }
        }, initialDelay, period, timeUnit);
    }

    @Override
    protected void doPublish(String queue, String jobJson) {
        this.ensureJedisConnection();
        AdminClientImpl.doPublish(this.jedis, this.getNamespace(), queue, jobJson);
    }

    @Override
    public void end() {
        if (this.keepAliveService != null) {
            this.keepAliveService.shutdownNow();
        }
        this.jedis.quit();
    }

    private void authenticateAndSelectDB() {
        if (this.config.getPassword() != null) {
            this.jedis.auth(this.config.getPassword());
        }
        this.jedis.select(this.config.getDatabase());
    }

    private void ensureJedisConnection() {
        if (this.checkConnectionBeforeUse && !JedisUtils.ensureJedisConnection(this.jedis)) {
            this.authenticateAndSelectDB();
        }
    }
}

