/*
 * Decompiled with CFR 0.152.
 */
package net.danlew.android.joda;

import android.util.Log;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ResUtils {
    private static final String TZDATA_PREFIX = "joda_";
    private static Map<Class<?>, Map<String, Integer>> sIdentifierCache = new ConcurrentHashMap();

    private static String convertPathToResource(String path) {
        File file = new File(path);
        ArrayList<String> parts = new ArrayList<String>();
        do {
            parts.add(file.getName());
        } while ((file = file.getParentFile()) != null);
        StringBuffer sb = new StringBuffer();
        int size = parts.size();
        for (int a = size - 1; a >= 0; --a) {
            if (sb.length() > 0) {
                sb.append("_");
            }
            sb.append((String)parts.get(a));
        }
        return sb.toString().replace('-', '_').replace("+", "plus").toLowerCase(Locale.US);
    }

    public static String getTzResource(String tzFile) {
        return TZDATA_PREFIX + ResUtils.convertPathToResource(tzFile);
    }

    public static String getZoneInfoMapResource() {
        return TZDATA_PREFIX + ResUtils.convertPathToResource("ZoneInfoMap");
    }

    public static int getIdentifier(Class<?> type, String name) {
        Map<Object, Object> typeCache;
        if (!sIdentifierCache.containsKey(type)) {
            typeCache = new ConcurrentHashMap();
            sIdentifierCache.put(type, typeCache);
        } else {
            typeCache = sIdentifierCache.get(type);
        }
        if (typeCache.containsKey(name)) {
            return (Integer)typeCache.get(name);
        }
        try {
            Field field = type.getField(name);
            int resId = field.getInt(null);
            if (resId != 0) {
                typeCache.put(name, resId);
            }
            return resId;
        }
        catch (Exception e) {
            Log.e((String)"JodaTimeAndroid", (String)("Failed to retrieve identifier: type=" + type + " name=" + name), (Throwable)e);
            return 0;
        }
    }
}

