/*
 * Decompiled with CFR 0.152.
 */
package jp.wasabeef.glide.transformations;

import android.content.Context;
import android.graphics.Bitmap;
import androidx.annotation.NonNull;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.TransformationUtils;
import java.security.MessageDigest;
import jp.wasabeef.glide.transformations.BitmapTransformation;

public class CropSquareTransformation
extends BitmapTransformation {
    private static final int VERSION = 1;
    private static final String ID = "jp.wasabeef.glide.transformations.CropSquareTransformation.1";
    private int size;

    @Override
    protected Bitmap transform(@NonNull Context context, @NonNull BitmapPool pool, @NonNull Bitmap toTransform, int outWidth, int outHeight) {
        this.size = Math.max(outWidth, outHeight);
        return TransformationUtils.centerCrop((BitmapPool)pool, (Bitmap)toTransform, (int)this.size, (int)this.size);
    }

    public String toString() {
        return "CropSquareTransformation(size=" + this.size + ")";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof CropSquareTransformation && ((CropSquareTransformation)o).size == this.size;
    }

    @Override
    public int hashCode() {
        return ID.hashCode() + this.size * 10;
    }

    @Override
    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.update((ID + this.size).getBytes(CHARSET));
    }
}

