/*
 * Decompiled with CFR 0.152.
 */
package it.xabaras.android.arootpermissionsdetector;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import java.io.File;
import java.io.IOException;

public final class ARootPermissionsDetector {
    public static boolean isRooted(Context context) {
        return ARootPermissionsDetector.hasSuperuserApk() || ARootPermissionsDetector.isTestKeyBuild() || ARootPermissionsDetector.isPackageInstalled("eu.chainfire.supersu", context) || ARootPermissionsDetector.canExecuteSuCommand();
    }

    private static boolean canExecuteSuCommand() {
        try {
            Runtime.getRuntime().exec("su");
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean hasSuperuserApk() {
        try {
            return new File("/system/app/Superuser.apk").exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isTestKeyBuild() {
        String str = Build.TAGS;
        return str != null && str.contains("test-keys");
    }

    private static boolean isPackageInstalled(String packagename, Context context) {
        PackageManager pm = context.getPackageManager();
        try {
            pm.getPackageInfo(packagename, 1);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }
}

