/*
 * Decompiled with CFR 0.152.
 */
package it.traeck.tools.openapi.validator;

import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="validate", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class ValidatorMojo
extends AbstractMojo {
    @Parameter(name="inputSpec", required=true)
    private String inputSpec;
    @Parameter(name="outputPath", property="openapi.validator.maven.plugin.outputPath", defaultValue="${project.build.directory}/generated-specification")
    private String outputPath;
    @Parameter(name="outputFilename", property="openapi.validator.maven.plugin.outputFilename", defaultValue="openapi")
    private String outputFilename = "openapi";
    @Parameter(name="outputFormat", property="openapi.validator.maven.plugin.outputFormat", defaultValue="JSON")
    private Format outputFormat = Format.JSON;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(name="encoding", property="openapi.validator.maven.plugin.encoding")
    private String encoding;
    private String projectEncoding = "UTF-8";
    @Parameter(name="prettyPrint", property="openapi.validator.maven.plugin.prettyPrint")
    private Boolean prettyPrint = true;

    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)String.format("Reading OpenAPI specification: %s", this.inputSpec));
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        SwaggerParseResult result = new OpenAPIParser().readLocation(this.inputSpec, (List)null, options);
        if (result == null || result.getMessages().size() > 0) {
            throw new MojoExecutionException(result == null ? "Failed for unknown reasons!" : Arrays.toString(result.getMessages().toArray()));
        }
        OpenAPI openAPI = result.getOpenAPI();
        try {
            Path path;
            File parentFile;
            this.determineEncoding();
            String openapiJson = null;
            String openapiYaml = null;
            if (Format.JSON.equals((Object)this.outputFormat) || Format.JSONANDYAML.equals((Object)this.outputFormat)) {
                openapiJson = this.prettyPrint != false ? Json.pretty((Object)openAPI) : Json.mapper().writeValueAsString((Object)openAPI);
            }
            if (Format.YAML.equals((Object)this.outputFormat) || Format.JSONANDYAML.equals((Object)this.outputFormat)) {
                openapiYaml = this.prettyPrint != false ? Yaml.pretty((Object)openAPI) : Yaml.mapper().writeValueAsString((Object)openAPI);
            }
            if ((parentFile = (path = Paths.get(this.outputPath, "temp")).toFile().getParentFile()) != null) {
                parentFile.mkdirs();
            }
            if (openapiJson != null) {
                path = Paths.get(this.outputPath, this.outputFilename + ".json");
                this.getLog().info((CharSequence)String.format("Writing: %s", path.toString()));
                Files.write(path, openapiJson.getBytes(Charset.forName(this.encoding)), new OpenOption[0]);
            }
            if (openapiYaml != null) {
                path = Paths.get(this.outputPath, this.outputFilename + ".yaml");
                this.getLog().info((CharSequence)String.format("Writing: %s", path.toString()));
                Files.write(path, openapiYaml.getBytes(Charset.forName(this.encoding)), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error writing API specification", (Throwable)e);
            throw new MojoExecutionException("Failed to write API specification", (Exception)e);
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error resolving API specification", (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void determineEncoding() {
        String pEnc;
        if (this.project != null && StringUtils.isNotBlank((CharSequence)(pEnc = this.project.getProperties().getProperty("project.build.sourceEncoding")))) {
            this.projectEncoding = pEnc;
        }
        if (StringUtils.isBlank((CharSequence)this.encoding)) {
            this.encoding = this.projectEncoding;
        }
        this.getLog().info((CharSequence)String.format("Using '%s' encoding to write output files.", this.encoding));
    }

    public static enum Format {
        JSON,
        YAML,
        JSONANDYAML;

    }
}

