/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisReplicas;
import io.vertx.redis.client.RedisReplicationConnectOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.CommandImpl;
import io.vertx.redis.client.impl.PooledRedisConnection;
import io.vertx.redis.client.impl.RequestImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;

public class RedisReplicationConnection
implements RedisConnection {
    private static final Logger LOG = LoggerFactory.getLogger(RedisReplicationConnection.class);
    private static final Random RANDOM = new Random();
    private static final List<Command> MASTER_ONLY_COMMANDS = new ArrayList<Command>();
    private final RedisReplicationConnectOptions connectOptions;
    private final PooledRedisConnection master;
    private final List<PooledRedisConnection> replicas;

    public static void addMasterOnlyCommand(Command command) {
        MASTER_ONLY_COMMANDS.add(command);
    }

    RedisReplicationConnection(Vertx vertx, RedisReplicationConnectOptions connectOptions, PooledRedisConnection master, List<PooledRedisConnection> replicas) {
        this.connectOptions = connectOptions;
        this.master = master;
        this.replicas = replicas;
    }

    @Override
    public RedisConnection exceptionHandler(Handler<Throwable> handler) {
        this.master.exceptionHandler((Handler)handler);
        for (RedisConnection redisConnection : this.replicas) {
            if (redisConnection == null) continue;
            redisConnection.exceptionHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public RedisConnection handler(Handler<Response> handler) {
        this.master.handler((Handler)handler);
        for (RedisConnection redisConnection : this.replicas) {
            if (redisConnection == null) continue;
            redisConnection.handler((Handler)handler);
        }
        return this;
    }

    @Override
    public RedisConnection pause() {
        this.master.pause();
        for (RedisConnection redisConnection : this.replicas) {
            if (redisConnection == null) continue;
            redisConnection.pause();
        }
        return this;
    }

    @Override
    public RedisConnection resume() {
        this.master.resume();
        for (RedisConnection redisConnection : this.replicas) {
            if (redisConnection == null) continue;
            redisConnection.resume();
        }
        return this;
    }

    @Override
    public RedisConnection fetch(long amount) {
        this.master.fetch(amount);
        for (RedisConnection redisConnection : this.replicas) {
            if (redisConnection == null) continue;
            redisConnection.fetch(amount);
        }
        return this;
    }

    @Override
    public RedisConnection endHandler(@Nullable Handler<Void> handler) {
        this.master.endHandler((Handler)handler);
        for (RedisConnection redisConnection : this.replicas) {
            if (redisConnection == null) continue;
            redisConnection.endHandler((Handler)handler);
        }
        return this;
    }

    @Override
    public Future<Response> send(Request request) {
        RequestImpl req = (RequestImpl)request;
        CommandImpl cmd = (CommandImpl)req.command();
        boolean forceMasterEndpoint = MASTER_ONLY_COMMANDS.contains(cmd);
        return this.selectMasterOrReplicaEndpoint(cmd.isReadOnly(req.getArgs()), forceMasterEndpoint).send(request);
    }

    @Override
    public Future<List<Response>> batch(List<Request> requests) {
        if (requests.isEmpty()) {
            LOG.debug((Object)"Empty batch");
            return Future.succeededFuture(Collections.emptyList());
        }
        boolean readOnly = false;
        boolean forceMasterEndpoint = false;
        for (Request request : requests) {
            RequestImpl req = (RequestImpl)request;
            CommandImpl cmd = (CommandImpl)req.command();
            readOnly |= cmd.isReadOnly(req.getArgs());
            forceMasterEndpoint |= MASTER_ONLY_COMMANDS.contains(cmd);
        }
        return this.selectMasterOrReplicaEndpoint(readOnly, forceMasterEndpoint).batch(requests);
    }

    @Override
    public Future<Void> close() {
        ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
        futures.add(this.master.close());
        for (RedisConnection redisConnection : this.replicas) {
            if (redisConnection == null) continue;
            futures.add(redisConnection.close());
        }
        return CompositeFuture.all(futures).mapEmpty();
    }

    @Override
    public boolean pendingQueueFull() {
        boolean result = this.master.pendingQueueFull();
        for (RedisConnection redisConnection : this.replicas) {
            if (redisConnection == null) continue;
            result |= redisConnection.pendingQueueFull();
        }
        return result;
    }

    private PooledRedisConnection selectMasterOrReplicaEndpoint(boolean read, boolean forceMasterEndpoint) {
        if (forceMasterEndpoint) {
            return this.master;
        }
        RedisReplicas useReplicas = this.connectOptions.getUseReplicas();
        if (read && useReplicas != RedisReplicas.NEVER && !this.replicas.isEmpty()) {
            switch (useReplicas) {
                case ALWAYS: {
                    return this.replicas.get(RANDOM.nextInt(this.replicas.size()));
                }
                case SHARE: {
                    int r = RANDOM.nextInt(this.replicas.size() + 1);
                    if (r == 0) {
                        return this.master;
                    }
                    return this.replicas.get(r - 1);
                }
            }
        }
        return this.master;
    }
}

