/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.oas.inflector;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.fasterxml.jackson.jaxrs.xml.JacksonJaxbXMLProvider;
import com.fasterxml.jackson.jaxrs.yaml.JacksonYAMLProvider;
import io.swagger.oas.inflector.config.Configuration;
import io.swagger.oas.inflector.config.ExposedSpecOptions;
import io.swagger.oas.inflector.config.FilterFactory;
import io.swagger.oas.inflector.controllers.InflectResultController;
import io.swagger.oas.inflector.controllers.OpenAPIOperationController;
import io.swagger.oas.inflector.controllers.OpenAPIResourceController;
import io.swagger.oas.inflector.converters.Converter;
import io.swagger.oas.inflector.converters.InputConverter;
import io.swagger.oas.inflector.models.InflectResult;
import io.swagger.oas.inflector.processors.EntityProcessor;
import io.swagger.oas.inflector.processors.EntityProcessorFactory;
import io.swagger.oas.inflector.processors.JacksonProcessor;
import io.swagger.oas.inflector.processors.JsonExampleProvider;
import io.swagger.oas.inflector.processors.JsonNodeExampleSerializer;
import io.swagger.oas.inflector.processors.JsonProvider;
import io.swagger.oas.inflector.processors.PlainExampleProvider;
import io.swagger.oas.inflector.processors.PlainProcessor;
import io.swagger.oas.inflector.processors.XMLExampleProvider;
import io.swagger.oas.inflector.processors.YamlExampleProvider;
import io.swagger.oas.inflector.utils.DefaultContentTypeProvider;
import io.swagger.oas.inflector.utils.DefaultSpecFilter;
import io.swagger.oas.inflector.utils.ExtensionsUtil;
import io.swagger.oas.inflector.validators.Validator;
import io.swagger.v3.core.filter.OpenAPISpecFilter;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.jaxrs2.SwaggerSerializers;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.File;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.net.ssl.SSLHandshakeException;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.process.Inflector;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenAPIInflector
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenAPIInflector.class);
    private Configuration config;
    private String basePath;
    private String originalBasePath;
    private ServletContext servletContext;
    private Map<String, List<String>> missingOperations = new HashMap<String, List<String>>();
    private Set<String> unimplementedMappedModels = new TreeSet<String>();
    private ObjectMapper objectMapper;

    public OpenAPIInflector(Configuration configuration) {
        this(configuration, Json.mapper());
    }

    public OpenAPIInflector(Configuration configuration, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.init(configuration);
    }

    public OpenAPIInflector(@Context ServletContext ctx) {
        this.servletContext = ctx;
        Configuration config = null;
        if (this.servletContext != null && this.servletContext.getInitParameter("inflector-config") != null) {
            try {
                config = Configuration.read(this.servletContext.getInitParameter("inflector-config"));
            }
            catch (Exception e) {
                LOGGER.error("unable to read configuration from init param");
            }
        }
        if (config == null) {
            config = Configuration.read();
        }
        this.objectMapper = Json.mapper();
        this.init(config);
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected void init(Configuration configuration) {
        String clsName;
        this.config = configuration;
        ParseOptions options = new ParseOptions();
        options.setResolve(true);
        options.setResolveFully(true);
        SwaggerParseResult swaggerParseResult = new OpenAPIV3Parser().readLocation(this.config.getSwaggerUrl(), null, options);
        if (!swaggerParseResult.getMessages().isEmpty()) {
            for (String message : swaggerParseResult.getMessages()) {
                LOGGER.warn(message);
            }
        }
        OpenAPI openAPI = swaggerParseResult.getOpenAPI();
        OpenAPI exposedAPI = this.getExposedAPI(this.config);
        if (!this.config.getValidatePayloads().isEmpty()) {
            LOGGER.info("resolving openAPI");
            new ExtensionsUtil().addExtensions(openAPI);
        }
        if (openAPI != null) {
            String basePath = null;
            List servers = openAPI.getServers();
            if (servers != null && servers.size() > 0) {
                String string = ((Server)servers.get(0)).getUrl();
                if (StringUtils.isNotBlank((CharSequence)((Server)servers.get(0)).getUrl())) {
                    basePath = string.substring(string.lastIndexOf("/"));
                    this.originalBasePath = string.substring(string.lastIndexOf("/"));
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (!"".equals(configuration.getRootPath())) {
                stringBuilder.append(configuration.getRootPath());
            }
            if (basePath != null) {
                stringBuilder.append(basePath);
            }
            if (stringBuilder.length() > 0) {
                ((Server)openAPI.getServers().get(0)).setUrl(stringBuilder.toString());
                if (configuration.getExposedSpecOptions().isMergeRootPath()) {
                    ((Server)exposedAPI.getServers().get(0)).setUrl(stringBuilder.toString());
                }
            }
            Paths paths = openAPI.getPaths();
            Map definitions = null;
            definitions = openAPI.getComponents() == null || openAPI.getComponents().getSchemas() == null ? new HashMap() : openAPI.getComponents().getSchemas();
            for (String pathString : paths.keySet()) {
                PathItem pathItem = (PathItem)paths.get(pathString);
                Resource.Builder builder = Resource.builder();
                this.basePath = configuration.getRootPath() + ((Server)openAPI.getServers().get(0)).getUrl();
                builder.path(OpenAPIInflector.basePath(this.originalBasePath, pathString));
                Operation operation = pathItem.getGet();
                if (operation != null) {
                    this.addOperation(pathString, builder, "GET", operation, definitions);
                }
                if ((operation = pathItem.getHead()) != null) {
                    this.addOperation(pathString, builder, "HEAD", operation, definitions);
                }
                if ((operation = pathItem.getPost()) != null) {
                    this.addOperation(pathString, builder, "POST", operation, definitions);
                }
                if ((operation = pathItem.getPut()) != null) {
                    this.addOperation(pathString, builder, "PUT", operation, definitions);
                }
                if ((operation = pathItem.getDelete()) != null) {
                    this.addOperation(pathString, builder, "DELETE", operation, definitions);
                }
                if ((operation = pathItem.getOptions()) != null) {
                    this.addOperation(pathString, builder, "OPTIONS", operation, definitions);
                }
                if ((operation = pathItem.getPatch()) != null) {
                    this.addOperation(pathString, builder, "PATCH", operation, definitions);
                }
                this.registerResources(new Resource[]{builder.build()});
            }
        } else {
            LOGGER.error("No openAPI definition detected!  Not much to do...");
        }
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.addSerializer((JsonSerializer)new JsonNodeExampleSerializer());
        if (this.config.getFilterClass() != null) {
            if (!this.config.getFilterClass().isEmpty()) {
                try {
                    FilterFactory.setFilter((OpenAPISpecFilter)OpenAPIInflector.class.getClassLoader().loadClass(this.config.getFilterClass()).newInstance());
                }
                catch (Exception e) {
                    LOGGER.error("Unable to set filter class " + this.config.getFilterClass());
                }
            }
        } else {
            FilterFactory.setFilter((OpenAPISpecFilter)new DefaultSpecFilter());
        }
        if (openAPI == null) {
            LOGGER.error("the openAPI definition is not valid");
        }
        for (String string : this.config.getEntityProcessors()) {
            if ("json".equalsIgnoreCase(string)) {
                this.getObjectMapper().registerModule((Module)simpleModule);
                this.register(JacksonJsonProvider.class);
                this.register(JsonExampleProvider.class);
                if (!this.getObjectMapper().isEnabled(SerializationFeature.INDENT_OUTPUT)) {
                    this.register(new JsonProvider(this.config.isPrettyPrint()));
                }
                if (!this.isRegistered(DefaultContentTypeProvider.class)) {
                    this.register(new DefaultContentTypeProvider(MediaType.APPLICATION_JSON_TYPE), new Class[]{ContextResolver.class});
                }
                this.enableProcessor(JacksonProcessor.class, MediaType.APPLICATION_JSON_TYPE);
                this.enableSwaggerJSON(exposedAPI, configuration.getSwaggerProcessors());
                continue;
            }
            if ("xml".equalsIgnoreCase(string)) {
                if (!this.isRegistered(DefaultContentTypeProvider.class)) {
                    this.register(new DefaultContentTypeProvider(MediaType.APPLICATION_XML_TYPE), new Class[]{ContextResolver.class});
                }
                this.enableProcessor(JacksonProcessor.class, MediaType.APPLICATION_XML_TYPE);
                this.register(JacksonJaxbXMLProvider.class);
                this.register(XMLExampleProvider.class);
                continue;
            }
            if ("yaml".equalsIgnoreCase(string)) {
                Yaml.mapper().registerModule((Module)simpleModule);
                this.register(YamlExampleProvider.class);
                this.register(JacksonYAMLProvider.class);
                this.enableProcessor(JacksonProcessor.class, JacksonProcessor.APPLICATION_YAML_TYPE);
                this.enableSwaggerYAML(exposedAPI, configuration.getSwaggerProcessors());
                continue;
            }
            if (!"plain".equalsIgnoreCase(string)) continue;
            this.register(PlainExampleProvider.class);
            this.enableProcessor(PlainProcessor.class, MediaType.TEXT_PLAIN_TYPE);
        }
        this.register(new MultiPartFeature());
        this.register(SwaggerSerializers.class);
        SwaggerSerializers.setPrettyPrint((boolean)this.config.isPrettyPrint());
        for (Class clazz : this.config.getExceptionMappers()) {
            this.register(clazz);
        }
        if (this.config.getInputValidators() != null && this.config.getInputValidators().size() > 0) {
            InputConverter.getInstance().getValidators().clear();
            for (String string : this.config.getInputValidators()) {
                try {
                    clsName = string;
                    if ("requiredFieldValidator".equalsIgnoreCase(string)) {
                        clsName = "io.swagger.oas.inflector.validators.DefaultValidator";
                    }
                    if ("numericValidator".equalsIgnoreCase(string)) {
                        clsName = "io.swagger.oas.inflector.validators.NumericValidator";
                    }
                    if ("stringValidator".equalsIgnoreCase(string)) {
                        clsName = "io.swagger.oas.inflector.validators.StringTypeValidator";
                    }
                    InputConverter.getInstance().addValidator((Validator)Class.forName(clsName).newInstance());
                }
                catch (Exception e) {
                    LOGGER.warn("unable to add validator `" + string + "`");
                    e.printStackTrace();
                }
            }
        } else {
            InputConverter.getInstance().defaultValidators();
        }
        if (this.config.getInputConverters() != null && this.config.getInputConverters().size() > 0) {
            InputConverter.getInstance().getConverters().clear();
            for (String string : this.config.getInputConverters()) {
                try {
                    clsName = string;
                    if ("defaultConverter".equalsIgnoreCase(string)) {
                        clsName = "io.swagger.oas.inflector.converters.DefaultConverter";
                    }
                    LOGGER.debug("adding converter `" + clsName + "`");
                    InputConverter.getInstance().addConverter((Converter)Class.forName(clsName).newInstance());
                }
                catch (Exception e) {
                    LOGGER.warn("unable to add validator `" + string + "`");
                }
            }
        } else {
            InputConverter.getInstance().defaultConverters();
        }
        InflectResult result = new InflectResult();
        for (String key : swaggerParseResult.getMessages()) {
            result.specParseMessage(key);
        }
        for (String key : this.missingOperations.keySet()) {
            result.unimplementedControllers(key, this.missingOperations.get(key));
        }
        for (String model : this.config.getUnimplementedModels()) {
            result.unimplementedModel(model);
        }
        for (String model : this.unimplementedMappedModels) {
            result.unimplementedModel(model);
        }
        if (Configuration.Environment.DEVELOPMENT.equals((Object)configuration.getEnvironment())) {
            if (this.missingOperations.size() > 0) {
                LOGGER.debug("There are unimplemented operations!");
            }
            for (String key : this.missingOperations.keySet()) {
                LOGGER.debug(key);
                for (String val : this.missingOperations.get(key)) {
                    LOGGER.debug(" - " + val);
                }
            }
            Resource.Builder builder = Resource.builder();
            String debugPath = this.config.getSwaggerBase().endsWith("/") ? OpenAPIInflector.basePath(this.originalBasePath, this.config.getSwaggerBase() + "debug.json") : OpenAPIInflector.basePath(this.originalBasePath, this.config.getSwaggerBase() + "/debug.json");
            LOGGER.debug("using debug path: `" + debugPath + "`");
            builder.path(debugPath).addMethod("GET").produces(new String[]{"application/json"}).handledBy((Inflector)new InflectResultController(result)).build();
            this.registerResources(new Resource[]{builder.build()});
        } else if (Configuration.Environment.STAGING.equals((Object)configuration.getEnvironment())) {
            if (this.missingOperations.size() > 0) {
                LOGGER.warn("There are unimplemented operations!");
            }
            for (String key : this.missingOperations.keySet()) {
                LOGGER.warn(key);
                for (String val : this.missingOperations.get(key)) {
                    LOGGER.warn(" - " + val);
                }
            }
        } else if (Configuration.Environment.PRODUCTION.equals((Object)configuration.getEnvironment())) {
            if (this.missingOperations.size() > 0) {
                LOGGER.error("There are unimplemented operations!");
            }
            for (String key : this.missingOperations.keySet()) {
                LOGGER.error(key);
                for (String val : this.missingOperations.get(key)) {
                    LOGGER.error(" - " + val);
                }
            }
            if (this.missingOperations.size() > 0) {
                LOGGER.error("Unable to start due to unimplemented methods");
                throw new RuntimeException("Unable to start due to unimplemented methods");
            }
        }
    }

    public static String basePath(String basePath, String path) {
        if (StringUtils.isBlank((CharSequence)basePath)) {
            basePath = "/";
        }
        if (!basePath.endsWith("/") && !"/".equals(basePath) && StringUtils.isBlank((CharSequence)path)) {
            basePath = basePath + "/";
        }
        if (StringUtils.isEmpty((CharSequence)path)) {
            return basePath;
        }
        if (path.equals("/")) {
            return basePath + "/";
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if ("/".equals(basePath)) {
            basePath = "";
        }
        if (basePath.endsWith("/") && path.startsWith("/")) {
            path = path.substring(1);
        }
        return basePath + path;
    }

    private void enableProcessor(Class<?> cls, MediaType type) {
        List<EntityProcessor> processors = EntityProcessorFactory.getProcessors();
        for (EntityProcessor processor : processors) {
            if (!processor.getClass().equals(cls)) continue;
            processor.enableType(type);
            return;
        }
        try {
            EntityProcessor processor = (EntityProcessor)cls.newInstance();
            processor.enableType(type);
        }
        catch (Exception e) {
            LOGGER.error("unable to initialize class " + cls);
        }
    }

    private void enableSwaggerJSON(OpenAPI openAPI, List<String> swaggerProcessors) {
        Resource.Builder builder = Resource.builder();
        builder.path(OpenAPIInflector.basePath(this.originalBasePath, StringUtils.appendIfMissing((String)this.config.getSwaggerBase(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "openapi.json")).addMethod("GET").produces(new String[]{"application/json"}).handledBy((Inflector)new OpenAPIResourceController(openAPI, swaggerProcessors)).build();
        this.registerResources(new Resource[]{builder.build()});
    }

    private void enableSwaggerYAML(OpenAPI openAPI, List<String> swaggerProcessors) {
        Resource.Builder builder = Resource.builder();
        builder.path(OpenAPIInflector.basePath(this.originalBasePath, StringUtils.appendIfMissing((String)this.config.getSwaggerBase(), (CharSequence)"/", (CharSequence[])new CharSequence[0]) + "openapi.yaml")).addMethod("GET").produces(new String[]{"application/yaml"}).handledBy((Inflector)new OpenAPIResourceController(openAPI, swaggerProcessors)).build();
        this.registerResources(new Resource[]{builder.build()});
    }

    private void addOperation(String pathString, Resource.Builder builder, String method, Operation operation, Map<String, Schema> definitions) {
        LOGGER.debug("adding operation for `" + pathString + "` " + method);
        if (operation.getRequestBody() != null) {
            RequestBody body = operation.getRequestBody();
            if (body.getContent() != null) {
                Content content = body.getContent();
                for (String mediaType : content.keySet()) {
                    if (content.get(mediaType) == null) continue;
                    OpenAPIOperationController controller = this.createController(pathString, method, operation, mediaType, definitions);
                    this.addConsumesToResource(mediaType, builder, method, controller);
                }
            }
        } else {
            OpenAPIOperationController controller = this.createController(pathString, method, operation, "", definitions);
            this.addConsumesToResource("", builder, method, controller);
        }
    }

    private OpenAPIOperationController createController(String pathString, String method, Operation operation, String mediaType, Map<String, Schema> definitions) {
        OpenAPIOperationController controller = new OpenAPIOperationController(this.config, pathString, method, operation, mediaType, definitions);
        if (controller.getMethod() == null && controller.getMethodName() != null) {
            List<String> missingMethods = this.missingOperations.get(controller.getControllerName());
            if (missingMethods == null) {
                missingMethods = new ArrayList<String>();
                this.missingOperations.put(controller.getControllerName(), missingMethods);
            }
            missingMethods.add(controller.getOperationSignature());
        }
        this.unimplementedMappedModels.addAll(controller.getUnimplementedMappedModels());
        return controller;
    }

    private void addConsumesToResource(String mediaType, Resource.Builder builder, String method, OpenAPIOperationController controller) {
        block5: {
            if (StringUtils.isNotBlank((CharSequence)mediaType)) {
                try {
                    MediaType media = MediaType.valueOf((String)mediaType);
                    if (media.getSubtype().equals("yaml")) {
                        builder.addMethod(method).handledBy((Inflector)controller);
                        break block5;
                    }
                    builder.addMethod(method).handledBy((Inflector)controller).consumes(new String[]{media.toString()});
                }
                catch (Exception e) {
                    LOGGER.error("unable to find a matching mediatype for " + mediaType + " in " + controller.getMethodName());
                }
            } else {
                builder.addMethod(method).handledBy((Inflector)controller);
            }
        }
    }

    private OpenAPI getExposedAPI(Configuration config) {
        ExposedSpecOptions exposedSpecOptions = config.getExposedSpecOptions();
        boolean hideExtension = exposedSpecOptions.isHideInflectorExtensions();
        OpenAPI exposedAPI = null;
        if (exposedSpecOptions.isUseOriginalNotParsed()) {
            exposedAPI = this.deserializeSpec(config.getSwaggerUrl());
        }
        if (exposedAPI == null) {
            SwaggerParseResult exposedSwaggerParseResult = new OpenAPIV3Parser().readLocation(config.getSwaggerUrl(), null, exposedSpecOptions.getParseOptions());
            exposedAPI = exposedSwaggerParseResult.getOpenAPI();
        }
        if (hideExtension) {
            new ExtensionsUtil().removeExtensions(exposedAPI);
        } else {
            new ExtensionsUtil().addExtensions(exposedAPI);
        }
        return exposedAPI;
    }

    private OpenAPI deserializeSpec(String swaggerUrl) {
        OpenAPI exposedAPI = null;
        String location = this.config.getSwaggerUrl().replaceAll("\\\\", "/");
        try {
            String data = null;
            if (location.toLowerCase().startsWith("http")) {
                data = RemoteUrl.urlToString((String)location, null);
            } else {
                String fileScheme = "file:";
                Path path = location.toLowerCase().startsWith("file:") ? java.nio.file.Paths.get(URI.create(location)) : java.nio.file.Paths.get(location, new String[0]);
                data = Files.exists(path, new LinkOption[0]) ? FileUtils.readFileToString((File)path.toFile(), (String)"UTF-8") : ClasspathHelper.loadFileFromClasspath((String)location);
                exposedAPI = (OpenAPI)this.getRightMapper(data).readValue(data, OpenAPI.class);
            }
        }
        catch (SSLHandshakeException e) {
            LOGGER.error("unable to read location `" + location + "` due to a SSL configuration error.  It is possible that the server SSL certificate is invalid, self-signed, or has an untrusted Certificate Authority.", (Throwable)e);
        }
        catch (Exception e1) {
            LOGGER.error("unable to read location `" + location + "`", (Throwable)e1);
        }
        return exposedAPI;
    }

    private ObjectMapper getRightMapper(String data) {
        ObjectMapper mapper = data.trim().startsWith("{") ? Json.mapper() : Yaml.mapper();
        return mapper;
    }
}

