/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.transform.migrate.resourcelisting;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import io.swagger.transform.migrate.SwaggerMigrator;
import io.swagger.transform.util.SwaggerMigrationException;
import javax.annotation.Nonnull;
import javax.annotation.Untainted;

public final class PathAppenderMigrator
implements SwaggerMigrator {
    private final String basePath;

    public PathAppenderMigrator(@Untainted @Nonnull String basePath) {
        this.basePath = basePath;
    }

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        try {
            Preconditions.checkArgument((boolean)input.isObject(), (Object)"expected JSON to be a JSON object but it isn't");
            Preconditions.checkArgument((boolean)input.path("path").isTextual(), (Object)"\"path\" member of API object is not a JSON string");
        }
        catch (IllegalArgumentException e) {
            throw new SwaggerMigrationException(e.getMessage());
        }
        ObjectNode node = (ObjectNode)input.deepCopy();
        String oldPath = node.get("path").textValue();
        node.put("path", this.basePath + oldPath);
        return node;
    }
}

