/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.languages;

import io.swagger.codegen.CodegenConfig;
import io.swagger.codegen.CodegenType;
import io.swagger.codegen.SupportingFile;
import io.swagger.codegen.languages.AbstractCppCodegen;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.BaseIntegerProperty;
import io.swagger.models.properties.BooleanProperty;
import io.swagger.models.properties.DateProperty;
import io.swagger.models.properties.DateTimeProperty;
import io.swagger.models.properties.DecimalProperty;
import io.swagger.models.properties.DoubleProperty;
import io.swagger.models.properties.FloatProperty;
import io.swagger.models.properties.IntegerProperty;
import io.swagger.models.properties.LongProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.StringProperty;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UE4CPPGenerator
extends AbstractCppCodegen
implements CodegenConfig {
    public static final String CPP_NAMESPACE = "cppNamespace";
    public static final String CPP_NAMESPACE_DESC = "C++ namespace (convention: name::space::for::api).";
    public static final String UNREAL_MODULE_NAME = "unrealModuleName";
    public static final String UNREAL_MODULE_NAME_DESC = "Name of the generated unreal module (optional)";
    public static final String OPTIONAL_PROJECT_FILE_DESC = "Generate Build.cs";
    protected String unrealModuleName = "Swagger";
    protected Set<String> pointerClasses = new HashSet<String>();
    protected String privateFolder = "Private";
    protected String publicFolder = "Public";
    protected String apiVersion = "1.0.0";
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Set<String> systemIncludes = new HashSet<String>();
    protected String cppNamespace = this.unrealModuleName;
    protected boolean optionalProjectFileFlag = true;

    public UE4CPPGenerator() {
        this.outputFolder = "generated-code/ue4cpp";
        if (this.modelNamePrefix == "") {
            this.modelNamePrefix = this.unrealModuleName;
        }
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-source.mustache", ".cpp");
        this.apiTemplateFiles.put("api-operations-header.mustache", ".h");
        this.apiTemplateFiles.put("api-operations-source.mustache", ".cpp");
        this.templateDir = "ue4cpp";
        this.embeddedTemplateDir = "ue4cpp";
        this.addOption(CPP_NAMESPACE, CPP_NAMESPACE_DESC, this.cppNamespace);
        this.addOption(UNREAL_MODULE_NAME, UNREAL_MODULE_NAME_DESC, this.unrealModuleName);
        this.addSwitch("optionalProjectFile", OPTIONAL_PROJECT_FILE_DESC, this.optionalProjectFileFlag);
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties().put("modelNamePrefix", this.modelNamePrefix);
        this.additionalProperties().put("modelPackage", this.modelPackage);
        this.additionalProperties().put("apiPackage", this.apiPackage);
        this.additionalProperties().put("dllapi", this.unrealModuleName.toUpperCase() + "_API");
        this.additionalProperties().put(UNREAL_MODULE_NAME, this.unrealModuleName);
        this.additionalProperties.put(CPP_NAMESPACE, this.cppNamespace);
        this.additionalProperties.put(UNREAL_MODULE_NAME, this.unrealModuleName);
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("bool", "int32", "int64", "float", "double", "FString", "FDateTime", "FGuid", "TArray", "TArray<uint8>", "TMap", "TSharedPtr<FJsonObject>"));
        this.supportingFiles.add(new SupportingFile("model-base-header.mustache", this.publicFolder, this.modelNamePrefix + "BaseModel.h"));
        this.supportingFiles.add(new SupportingFile("model-base-source.mustache", this.privateFolder, this.modelNamePrefix + "BaseModel.cpp"));
        this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.publicFolder, this.modelNamePrefix + "Helpers.h"));
        this.supportingFiles.add(new SupportingFile("helpers-source.mustache", this.privateFolder, this.modelNamePrefix + "Helpers.cpp"));
        if (this.optionalProjectFileFlag) {
            this.supportingFiles.add(new SupportingFile("Build.cs.mustache", this.unrealModuleName + ".Build.cs"));
            this.supportingFiles.add(new SupportingFile("module-header.mustache", this.privateFolder, this.unrealModuleName + "Module.h"));
            this.supportingFiles.add(new SupportingFile("module-source.mustache", this.privateFolder, this.unrealModuleName + "Module.cpp"));
        }
        this.typeMapping = new HashMap();
        this.typeMapping.clear();
        this.typeMapping.put("integer", "int32");
        this.typeMapping.put("long", "int64");
        this.typeMapping.put("float", "float");
        this.typeMapping.put("number", "double");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("string", "FString");
        this.typeMapping.put("byte", "uint8");
        this.typeMapping.put("binary", "TArray<uint8>");
        this.typeMapping.put("ByteArray", "TArray<uint8>");
        this.typeMapping.put("password", "FString");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("date", "FDateTime");
        this.typeMapping.put("Date", "FDateTime");
        this.typeMapping.put("date-time", "FDateTime");
        this.typeMapping.put("DateTime", "FDateTime");
        this.typeMapping.put("array", "TArray");
        this.typeMapping.put("list", "TArray");
        this.typeMapping.put("map", "TMap");
        this.typeMapping.put("object", "TSharedPtr<FJsonObject>");
        this.typeMapping.put("Object", "TSharedPtr<FJsonObject>");
        this.typeMapping.put("file", "HttpFileInput");
        this.typeMapping.put("UUID", "FGuid");
        this.importMapping = new HashMap();
        this.importMapping.put("HttpFileInput", "#include \"" + this.modelNamePrefix + "Helpers.h\"");
        this.namespaces = new HashMap<String, String>();
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CPP_NAMESPACE)) {
            this.cppNamespace = (String)this.additionalProperties.get(CPP_NAMESPACE);
        }
        this.additionalProperties.put("cppNamespaceDeclarations", this.cppNamespace.split("\\::"));
        boolean updateSupportingFiles = false;
        if (this.additionalProperties.containsKey(UNREAL_MODULE_NAME)) {
            this.unrealModuleName = (String)this.additionalProperties.get(UNREAL_MODULE_NAME);
            this.additionalProperties().put("dllapi", this.unrealModuleName.toUpperCase() + "_API");
            this.modelNamePrefix = this.unrealModuleName;
            updateSupportingFiles = true;
        }
        if (this.additionalProperties.containsKey("modelNamePrefix")) {
            this.modelNamePrefix = (String)this.additionalProperties.get("modelNamePrefix");
            updateSupportingFiles = true;
        }
        if (this.additionalProperties.containsKey("optionalProjectFile")) {
            this.setOptionalProjectFileFlag(this.convertPropertyToBooleanAndWriteBack("optionalProjectFile"));
        } else {
            this.additionalProperties.put("optionalProjectFile", this.optionalProjectFileFlag);
        }
        if (updateSupportingFiles) {
            this.supportingFiles.clear();
            this.supportingFiles.add(new SupportingFile("model-base-header.mustache", this.publicFolder, this.modelNamePrefix + "BaseModel.h"));
            this.supportingFiles.add(new SupportingFile("model-base-source.mustache", this.privateFolder, this.modelNamePrefix + "BaseModel.cpp"));
            this.supportingFiles.add(new SupportingFile("helpers-header.mustache", this.publicFolder, this.modelNamePrefix + "Helpers.h"));
            this.supportingFiles.add(new SupportingFile("helpers-source.mustache", this.privateFolder, this.modelNamePrefix + "Helpers.cpp"));
            if (this.optionalProjectFileFlag) {
                this.supportingFiles.add(new SupportingFile("Build.cs.mustache", this.unrealModuleName + ".Build.cs"));
                this.supportingFiles.add(new SupportingFile("module-header.mustache", this.privateFolder, this.unrealModuleName + "Module.h"));
                this.supportingFiles.add(new SupportingFile("module-source.mustache", this.privateFolder, this.unrealModuleName + "Module.cpp"));
            }
            this.importMapping.put("HttpFileInput", "#include \"" + this.modelNamePrefix + "Helpers.h\"");
        }
    }

    public void setOptionalProjectFileFlag(boolean flag) {
        this.optionalProjectFileFlag = flag;
    }

    @Override
    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    @Override
    public String getName() {
        return "ue4cpp";
    }

    @Override
    public String getHelp() {
        return "Generates a Unreal Engine 4 C++ Module.";
    }

    @Override
    public String toModelImport(String name) {
        if (this.namespaces.containsKey(name)) {
            return "using " + this.namespaces.get(name) + ";";
        }
        if (this.systemIncludes.contains(name)) {
            return "#include <" + name + ">";
        }
        String folder = this.modelPackage().replace("::", File.separator);
        if (!folder.isEmpty()) {
            folder = folder + File.separator;
        }
        return "#include \"" + folder + name + ".h\"";
    }

    @Override
    protected boolean needToImport(String type) {
        boolean shouldImport = super.needToImport(type);
        if (shouldImport) {
            return !this.languageSpecificPrimitives.contains(type);
        }
        return false;
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.modelPackage().replace("::", File.separator);
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace("::", File.separator);
    }

    @Override
    public String modelFilename(String templateName, String tag) {
        String suffix = this.modelTemplateFiles().get(templateName);
        String folder = this.privateFolder;
        if (suffix == ".h") {
            folder = this.publicFolder;
        }
        return this.modelFileFolder() + File.separator + folder + File.separator + this.toModelFilename(tag) + suffix;
    }

    @Override
    public String toModelFilename(String name) {
        name = this.sanitizeName(name);
        return this.modelNamePrefix + this.initialCaps(name);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        String folder = this.privateFolder;
        if (suffix == ".h") {
            folder = this.publicFolder;
        }
        if (templateName.startsWith("api-operations")) {
            return this.apiFileFolder() + File.separator + folder + File.separator + this.toApiFilename(tag) + "Operations" + suffix;
        }
        return this.apiFileFolder() + File.separator + folder + File.separator + this.toApiFilename(tag) + suffix;
    }

    @Override
    public String toApiFilename(String name) {
        name = this.sanitizeName(name);
        return this.modelNamePrefix + this.initialCaps(name) + "Api";
    }

    @Override
    public String getTypeDeclaration(Property p) {
        String swaggerType = this.getSwaggerType(p);
        if (p instanceof ArrayProperty) {
            ArrayProperty ap = (ArrayProperty)p;
            Property inner = ap.getItems();
            return this.getSwaggerType(p) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (p instanceof MapProperty) {
            MapProperty mp = (MapProperty)p;
            Property inner = mp.getAdditionalProperties();
            return this.getSwaggerType(p) + "<FString, " + this.getTypeDeclaration(inner) + ">";
        }
        if (this.pointerClasses.contains(swaggerType)) {
            return swaggerType + "*";
        }
        if (this.languageSpecificPrimitives.contains(swaggerType)) {
            return this.toModelName(swaggerType);
        }
        return swaggerType;
    }

    @Override
    public String toDefaultValue(Property p) {
        if (p instanceof StringProperty) {
            StringProperty sp = (StringProperty)p;
            if (sp.getDefault() != null) {
                return "TEXT(\"" + sp.getDefault().toString() + "\")";
            }
            return null;
        }
        if (p instanceof BooleanProperty) {
            BooleanProperty bp = (BooleanProperty)p;
            if (bp.getDefault() != null) {
                return bp.getDefault().toString();
            }
            return "false";
        }
        if (p instanceof DateProperty) {
            return "FDateTime(0)";
        }
        if (p instanceof DateTimeProperty) {
            return "FDateTime(0)";
        }
        if (p instanceof DoubleProperty) {
            DoubleProperty dp = (DoubleProperty)p;
            if (dp.getDefault() != null) {
                return dp.getDefault().toString();
            }
            return "0.0";
        }
        if (p instanceof FloatProperty) {
            FloatProperty fp = (FloatProperty)p;
            if (fp.getDefault() != null) {
                return fp.getDefault().toString();
            }
            return "0.0f";
        }
        if (p instanceof IntegerProperty) {
            IntegerProperty ip = (IntegerProperty)p;
            if (ip.getDefault() != null) {
                return ip.getDefault().toString();
            }
            return "0";
        }
        if (p instanceof LongProperty) {
            LongProperty lp = (LongProperty)p;
            if (lp.getDefault() != null) {
                return lp.getDefault().toString();
            }
            return "0";
        }
        if (p instanceof BaseIntegerProperty) {
            return "0";
        }
        if (p instanceof DecimalProperty) {
            return "0.0";
        }
        return null;
    }

    @Override
    public String getSwaggerType(Property p) {
        String swaggerType = super.getSwaggerType(p);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return this.toModelName(type);
            }
            if (this.pointerClasses.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        return this.toModelName(type);
    }

    @Override
    public String toModelName(String type) {
        if (this.typeMapping.keySet().contains(type) || this.typeMapping.values().contains(type) || this.importMapping.values().contains(type) || this.defaultIncludes.contains(type) || this.languageSpecificPrimitives.contains(type)) {
            return type;
        }
        type = this.sanitizeName(type);
        return this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1);
    }

    @Override
    public String toVarName(String name) {
        if ((name = this.sanitizeName(name)).matches("^[A-Z_]*$")) {
            name = name.toLowerCase();
        }
        if (this.isReservedWord(name) || name.matches("^\\d.*")) {
            name = this.escapeReservedWord(name);
        }
        return UE4CPPGenerator.camelize(name, false);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        objs = super.postProcessModels(objs);
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public String toEnumVarName(String name, String datatype) {
        return this.toVarName(name);
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toApiName(String type) {
        return this.modelNamePrefix + Character.toUpperCase(type.charAt(0)) + type.substring(1) + "Api";
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String sanitizeName(String name) {
        name = super.sanitizeName(name);
        name = name.replace(".", "_");
        return name;
    }

    @Override
    public String toBooleanGetter(String name) {
        return "Is" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toGetter(String name) {
        return "Get" + this.getterAndSetterCapitalize(name);
    }

    @Override
    public String toSetter(String name) {
        return "Set" + this.getterAndSetterCapitalize(name);
    }
}

