/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.java;

import com.google.common.collect.ImmutableMap;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.features.BeanValidationFeatures;
import io.swagger.codegen.v3.generators.features.NotNullAnnotationFeatures;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.generators.handlebars.lambda.UppercaseLambda;
import io.swagger.codegen.v3.generators.java.AbstractJavaCodegen;
import io.swagger.codegen.v3.utils.URLPathUtil;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaVertXServerCodegen
extends AbstractJavaCodegen
implements BeanValidationFeatures,
NotNullAnnotationFeatures {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaVertXServerCodegen.class);
    private static final String ROOT_PACKAGE = "rootPackage";
    private static final String VERTICLE_PACKAGE = "verticlePackage";
    private static final String SPEC_LOCATION = "openapi.yaml";
    private static final String OPENAPI_EXTENSION = "x-vertx-event-bus";
    private static final String OPENAPI_EXTENSION_ADDRESS = "address";
    private static final String OPENAPI_EXTENSION_METHOD_NAME = "method";
    private static final String TITLE = "title";
    public static final String RX_INTERFACE_OPTION = "rxInterface";
    public static final String USE_DATAOBJECT_OPTION = "useDataObject";
    public static final String MOUNT_OPERATION_FROM_OPTION = "mountOperationFrom";
    public static final String MOUNT_OPERATION_FROM_EXTENSIONS = "mountFromExtensions";
    public static final String MOUNT_OPERATION_FROM_INTERFACE = "mountFromInterface";
    public static final String SPEC_LOCATION_OPTION = "specLocation";
    public static final String USE_FUTURE_OPTION = "useFuture";
    protected String rootPackage = "io.swagger.server.api";
    protected String apiVerticle;
    protected String apiVersion = "1.0.0-SNAPSHOT";
    protected boolean useDataObject = false;
    protected boolean mountFromExtensions = false;
    protected boolean mountFromInterface = false;
    protected String title = null;
    protected boolean useBeanValidation = false;
    protected boolean notNullJacksonAnnotation = false;

    public JavaVertXServerCodegen() {
        this.outputFolder = "generated-code" + File.separator + "javaVertXServer";
        this.apiPackage = this.rootPackage + ".service";
        this.apiVerticle = this.rootPackage + ".verticle";
        this.modelPackage = this.rootPackage + ".model";
        this.additionalProperties.put(ROOT_PACKAGE, this.rootPackage);
        this.additionalProperties.put(VERTICLE_PACKAGE, this.apiVerticle);
        this.groupId = "io.swagger";
        this.artifactId = "swagger-java-vertx-server";
        this.artifactVersion = this.apiVersion;
        this.cliOptions.add(CliOption.newBoolean((String)RX_INTERFACE_OPTION, (String)"When specified, API interfaces are generated with RX and methods return Single<> and Comparable."));
        this.cliOptions.add(CliOption.newBoolean((String)USE_DATAOBJECT_OPTION, (String)"When specified, models objects are generated with @DataObject"));
        CliOption operationsOption = CliOption.newString((String)MOUNT_OPERATION_FROM_OPTION, (String)"When specified, defines how operations are mounted. Default with @WebApiServiceGen");
        HashMap<String, String> mountOperationFromEnum = new HashMap<String, String>();
        mountOperationFromEnum.put(MOUNT_OPERATION_FROM_EXTENSIONS, "Mount operations from extensions with web-api-service module & @WebApiServiceGen. open api contract must define x-vertx-event-bus extension to be mounted");
        mountOperationFromEnum.put(MOUNT_OPERATION_FROM_INTERFACE, "Mount operations from interface with web-api-service module & Interfaces implementing operations. event bus address will be #{tag}.address");
        operationsOption.setEnum(mountOperationFromEnum);
        operationsOption.setDefault(MOUNT_OPERATION_FROM_EXTENSIONS);
        this.cliOptions.add(operationsOption);
        CliOption specLocation = CliOption.newString((String)SPEC_LOCATION_OPTION, (String)"When specified, define spec location. Default as openapi.yaml");
        specLocation.setDefault(SPEC_LOCATION);
        this.cliOptions.add(specLocation);
        CliOption useFutureOption = CliOption.newBoolean((String)USE_FUTURE_OPTION, (String)"When specified, describe service as future or not. Default as false");
        useFutureOption.setDefault(Boolean.FALSE.toString());
        this.cliOptions.add(useFutureOption);
        this.cliOptions.add(CliOption.newBoolean((String)"useBeanValidation", (String)"Use BeanValidation API annotations"));
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "java-vertx";
    }

    public String getHelp() {
        return "Generates a java-Vert.X Server library.";
    }

    @Override
    public String getDefaultTemplateDir() {
        return "JavaVertXServer";
    }

    @Override
    public void processOpts() {
        if (this.dateLibrary.equals("legacy")) {
            LOGGER.warn("Legacy date library could not be used. Replaced to java8 as default");
            this.setDateLibrary("java8");
        }
        super.processOpts();
        this.modelTemplateFiles.clear();
        this.modelTemplateFiles.put("model.mustache", ".java");
        this.apiTemplateFiles.clear();
        this.apiTemplateFiles.put("api.mustache", ".java");
        this.apiTestTemplateFiles.clear();
        this.modelDocTemplateFiles.clear();
        this.apiDocTemplateFiles.clear();
        if (this.additionalProperties.containsKey(USE_DATAOBJECT_OPTION)) {
            this.useDataObject = Boolean.valueOf(this.additionalProperties.get(USE_DATAOBJECT_OPTION).toString());
        }
        if (this.additionalProperties.containsKey(MOUNT_OPERATION_FROM_OPTION) && MOUNT_OPERATION_FROM_INTERFACE.equals(this.additionalProperties.get(MOUNT_OPERATION_FROM_OPTION))) {
            this.mountFromInterface = true;
            this.additionalProperties.put(MOUNT_OPERATION_FROM_INTERFACE, true);
        }
        if (!this.mountFromInterface) {
            this.mountFromExtensions = true;
            this.additionalProperties.put(MOUNT_OPERATION_FROM_EXTENSIONS, true);
        }
        if (!this.additionalProperties.containsKey(SPEC_LOCATION_OPTION)) {
            this.additionalProperties.put(SPEC_LOCATION_OPTION, SPEC_LOCATION);
        }
        this.supportingFiles.clear();
        this.supportingFiles.add(new SupportingFile("MainApiVerticle.mustache", this.sourceFolder + File.separator + this.rootPackage.replace(".", File.separator), "MainApiVerticle.java"));
        this.supportingFiles.add(new SupportingFile("package-info-service.mustache", this.sourceFolder + File.separator + this.apiPackage.replace(".", File.separator), "package-info.java"));
        if (this.useDataObject) {
            this.supportingFiles.add(new SupportingFile("package-info-model.mustache", this.sourceFolder + File.separator + this.modelPackage.replace(".", File.separator), "package-info.java"));
            this.supportingFiles.add(new SupportingFile("json-mappers.mustache", this.projectFolder + File.separator + "resources/META-INF/vertx", "json-mappers.properties"));
            this.supportingFiles.add(new SupportingFile("DataObjectMapper.mustache", this.sourceFolder + File.separator + this.modelPackage.replace(".", File.separator), "DataObjectMapper.java"));
        }
        this.writeOptional(this.outputFolder, new SupportingFile("pom.mustache", "", "pom.xml"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        this.addHandlebarsLambdas(this.additionalProperties);
    }

    @Override
    public void postProcessModelProperty(CodegenModel model, CodegenProperty property) {
        super.postProcessModelProperty(model, property);
        boolean isEnum = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-is-enum");
        if (!Boolean.TRUE.equals(isEnum)) {
            model.imports.add("JsonProperty");
            boolean hasEnums = ExtensionHelper.getBooleanValue((VendorExtendable)model, "x-has-enums");
            if (Boolean.TRUE.equals(hasEnums)) {
                model.imports.add("JsonValue");
            }
        }
        model.imports.remove("Schema");
    }

    @Override
    public CodegenModel fromModel(String name, Schema schema, Map<String, Schema> allSchemas) {
        CodegenModel codegenModel = super.fromModel(name, schema, allSchemas);
        codegenModel.imports.remove("ApiModel");
        codegenModel.imports.remove("ApiModelProperty");
        return codegenModel;
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        URL urlInfo = URLPathUtil.getServerURL((OpenAPI)openAPI);
        String port = "8080";
        if (urlInfo != null && urlInfo.getPort() > 0) {
            port = String.valueOf(urlInfo.getPort());
        }
        this.additionalProperties.put("serverPort", port);
        String title = openAPI.getInfo().getTitle();
        title = title.trim().replace(" ", "-");
        if (title.toUpperCase().endsWith("API")) {
            title = title.substring(0, title.length() - 3);
        }
        title = JavaVertXServerCodegen.camelize(this.sanitizeName(title));
        this.additionalProperties.put(TITLE, title);
        this.supportingFiles.add(new SupportingFile("apiVerticle.mustache", this.sourceFolder + File.separator + this.apiVerticle.replace(".", File.separator), title + "Verticle.java"));
        Paths paths = openAPI.getPaths();
        if (paths != null) {
            for (Map.Entry entry : paths.entrySet()) {
                this.manageOperations((PathItem)entry.getValue(), (String)entry.getKey());
            }
        }
        this.additionalProperties.remove("gson");
    }

    @Override
    public void setUseBeanValidation(boolean useBeanValidation) {
        this.useBeanValidation = useBeanValidation;
    }

    @Override
    public void setNotNullJacksonAnnotation(boolean notNullJacksonAnnotation) {
        this.notNullJacksonAnnotation = notNullJacksonAnnotation;
    }

    @Override
    public boolean isNotNullJacksonAnnotation() {
        return this.notNullJacksonAnnotation;
    }

    private void addHandlebarsLambdas(Map<String, Object> objs) {
        ImmutableMap lambdas = new ImmutableMap.Builder().put((Object)"uppercase", (Object)new UppercaseLambda()).build();
        if (objs.containsKey("lambda")) {
            LOGGER.warn("An property named 'lambda' already exists. Mustache lambdas renamed from 'lambda' to '_lambda'. You'll likely need to use a custom template, see https://github.com/swagger-api/swagger-codegen#modifying-the-client-library-format. ");
            objs.put("_lambda", lambdas);
        } else {
            objs.put("lambda", lambdas);
        }
    }

    private void manageOperations(PathItem pathItem, String pathname) {
        Map operationMap = pathItem.readOperationsMap();
        if (operationMap != null) {
            for (Map.Entry<PathItem.HttpMethod, Operation> entry : operationMap.entrySet()) {
                String serviceId = null;
                if (this.mountFromExtensions) {
                    Object pathExtension = this.getExtension(pathItem.getExtensions());
                    Object operationExtension = this.getExtension(entry.getValue().getExtensions());
                    String address = null;
                    if (operationExtension instanceof String && pathExtension instanceof String || pathExtension == null) {
                        if (operationExtension instanceof String) {
                            address = (String)operationExtension;
                        } else if (operationExtension instanceof Map) {
                            address = (String)((Map)operationExtension).get(OPENAPI_EXTENSION_ADDRESS);
                            serviceId = (String)((Map)operationExtension).get(OPENAPI_EXTENSION_METHOD_NAME);
                        }
                    } else if (operationExtension instanceof String && pathExtension instanceof Map) {
                        address = ((Map)pathExtension).containsKey(OPENAPI_EXTENSION_ADDRESS) ? (String)((Map)pathExtension).get(OPENAPI_EXTENSION_ADDRESS) : (String)operationExtension;
                    } else if (operationExtension instanceof Map && pathExtension instanceof String) {
                        address = (String)pathExtension;
                        serviceId = (String)((Map)operationExtension).get(OPENAPI_EXTENSION_METHOD_NAME);
                    } else if (operationExtension instanceof Map && pathExtension instanceof Map) {
                        LinkedHashMap busExtension = new LinkedHashMap((Map)pathExtension);
                        busExtension.putAll((Map)operationExtension);
                        address = (String)busExtension.get(OPENAPI_EXTENSION_ADDRESS);
                        serviceId = (String)busExtension.get(OPENAPI_EXTENSION_METHOD_NAME);
                    } else if (operationExtension == null && pathExtension instanceof String) {
                        address = (String)pathExtension;
                    } else if (operationExtension == null && pathExtension instanceof Map) {
                        address = (String)((Map)pathExtension).get(OPENAPI_EXTENSION_ADDRESS);
                        serviceId = (String)((Map)pathExtension).get(OPENAPI_EXTENSION_METHOD_NAME);
                    }
                    if (null != address) {
                        entry.getValue().addExtension("x-event-bus-address", (Object)address);
                        entry.getValue().setTags(Collections.singletonList(address));
                    } else {
                        LOGGER.warn("event bus address not found on operationId {}, will not be mount", (Object)entry.getValue().getOperationId());
                    }
                }
                if (null == serviceId) {
                    serviceId = this.computeServiceId(pathname, entry);
                }
                ((Operation)entry.getValue()).addExtension("x-serviceid", (Object)this.sanitizeOperationId(serviceId));
            }
        }
    }

    private Object getExtension(Map<String, Object> extensions) {
        return null != extensions ? extensions.get(OPENAPI_EXTENSION) : null;
    }

    private String sanitizeOperationId(String operationId) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < operationId.length(); ++i) {
            char c = operationId.charAt(i);
            if (c == '-' || c == ' ' || c == '_') {
                try {
                    while (c == '-' || c == ' ' || c == '_') {
                        c = operationId.charAt(++i);
                    }
                    result.append(Character.toUpperCase(operationId.charAt(i)));
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private String computeServiceId(String pathname, Map.Entry<PathItem.HttpMethod, Operation> entry) {
        String operationId = entry.getValue().getOperationId();
        return operationId != null ? operationId : entry.getKey().name() + pathname.replaceAll("-", "_").replaceAll("/", "_").replaceAll("[{}]", "");
    }
}

