/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.dart;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DartClientCodegen
extends DefaultCodegenConfig {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DartClientCodegen.class);
    public static final String BROWSER_CLIENT = "browserClient";
    public static final String PUB_NAME = "pubName";
    public static final String PUB_VERSION = "pubVersion";
    public static final String PUB_DESCRIPTION = "pubDescription";
    public static final String USE_ENUM_EXTENSION = "useEnumExtension";
    protected boolean browserClient = true;
    protected String pubName = "swagger";
    protected String pubVersion = "1.0.0";
    protected String pubDescription = "Swagger API client";
    protected boolean useEnumExtension = false;
    protected String sourceFolder = "";
    protected String apiDocPath = "docs/";
    protected String modelDocPath = "docs/";

    public DartClientCodegen() {
        this.importMapping.clear();
        this.outputFolder = "generated-code/dart";
        this.modelTemplateFiles.put("model.mustache", ".dart");
        this.apiTemplateFiles.put("api.mustache", ".dart");
        this.apiTestTemplateFiles.put("api_test.mustache", ".dart");
        this.templateDir = "dart";
        this.embeddedTemplateDir = "dart";
        this.apiPackage = "lib.api";
        this.modelPackage = "lib.model";
        this.testPackage = "tests";
        this.modelDocTemplateFiles.put("object_doc.mustache", ".md");
        this.apiDocTemplateFiles.put("api_doc.mustache", ".md");
        this.hideGenerationTimestamp = Boolean.TRUE;
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "as", "assert", "async", "async*", "await", "break", "case", "catch", "class", "const", "continue", "default", "deferred", "do", "dynamic", "else", "enum", "export", "external", "extends", "factory", "false", "final", "finally", "for", "get", "if", "implements", "import", "in", "is", "library", "new", "null", "operator", "part", "rethrow", "return", "set", "static", "super", "switch", "sync*", "this", "throw", "true", "try", "typedef", "var", "void", "while", "int", "double", "with", "yield", "yield*"));
        this.languageSpecificPrimitives = new HashSet<String>(Arrays.asList("String", "bool", "int", "num", "double"));
        this.instantiationTypes.put("array", "List");
        this.instantiationTypes.put("map", "Map");
        this.typeMapping = new HashMap();
        this.typeMapping.put("Array", "List");
        this.typeMapping.put("array", "List");
        this.typeMapping.put("List", "List");
        this.typeMapping.put("boolean", "bool");
        this.typeMapping.put("string", "String");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("int", "int");
        this.typeMapping.put("long", "int");
        this.typeMapping.put("short", "int");
        this.typeMapping.put("number", "num");
        this.typeMapping.put("float", "double");
        this.typeMapping.put("double", "double");
        this.typeMapping.put("BigDecimal", "double");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("integer", "int");
        this.typeMapping.put("Date", "DateTime");
        this.typeMapping.put("date", "DateTime");
        this.typeMapping.put("File", "MultipartFile");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "String");
        this.cliOptions.add(new CliOption(BROWSER_CLIENT, "Is the client browser based"));
        this.cliOptions.add(new CliOption(PUB_NAME, "Name in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_VERSION, "Version in generated pubspec"));
        this.cliOptions.add(new CliOption(PUB_DESCRIPTION, "Description in generated pubspec"));
        this.cliOptions.add(new CliOption(USE_ENUM_EXTENSION, "Allow the 'x-enum-values' extension for enums"));
        this.cliOptions.add(new CliOption("sourceFolder", "source folder for generated code"));
    }

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return "dart";
    }

    public String getHelp() {
        return "Generates a Dart client library.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(BROWSER_CLIENT)) {
            this.setBrowserClient(this.convertPropertyToBooleanAndWriteBack(BROWSER_CLIENT));
        } else {
            this.additionalProperties.put(BROWSER_CLIENT, this.browserClient);
        }
        if (this.additionalProperties.containsKey(PUB_NAME)) {
            this.setPubName((String)this.additionalProperties.get(PUB_NAME));
        } else {
            this.additionalProperties.put(PUB_NAME, this.pubName);
        }
        if (this.additionalProperties.containsKey(PUB_VERSION)) {
            this.setPubVersion((String)this.additionalProperties.get(PUB_VERSION));
        } else {
            this.additionalProperties.put(PUB_VERSION, this.pubVersion);
        }
        if (this.additionalProperties.containsKey(PUB_DESCRIPTION)) {
            this.setPubDescription((String)this.additionalProperties.get(PUB_DESCRIPTION));
        } else {
            this.additionalProperties.put(PUB_DESCRIPTION, this.pubDescription);
        }
        if (this.additionalProperties.containsKey(USE_ENUM_EXTENSION)) {
            this.setUseEnumExtension(this.convertPropertyToBooleanAndWriteBack(USE_ENUM_EXTENSION));
        } else {
            this.additionalProperties.put(USE_ENUM_EXTENSION, this.useEnumExtension);
        }
        if (this.additionalProperties.containsKey("sourceFolder")) {
            this.setSourceFolder((String)this.additionalProperties.get("sourceFolder"));
        }
        this.additionalProperties.put("apiDocPath", this.apiDocPath);
        this.additionalProperties.put("modelDocPath", this.modelDocPath);
        String libFolder = this.sourceFolder + File.separator + "lib";
        this.supportingFiles.add(new SupportingFile("pubspec.mustache", "", "pubspec.yaml"));
        this.supportingFiles.add(new SupportingFile("analysis_options.mustache", "", ".analysis_options"));
        this.supportingFiles.add(new SupportingFile("api_client.mustache", libFolder, "api_client.dart"));
        this.supportingFiles.add(new SupportingFile("api_exception.mustache", libFolder, "api_exception.dart"));
        this.supportingFiles.add(new SupportingFile("api_helper.mustache", libFolder, "api_helper.dart"));
        this.supportingFiles.add(new SupportingFile("apilib.mustache", libFolder, "api.dart"));
        String authFolder = this.sourceFolder + File.separator + "lib" + File.separator + "auth";
        this.supportingFiles.add(new SupportingFile("auth/authentication.mustache", authFolder, "authentication.dart"));
        this.supportingFiles.add(new SupportingFile("auth/http_basic_auth.mustache", authFolder, "http_basic_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/api_key_auth.mustache", authFolder, "api_key_auth.dart"));
        this.supportingFiles.add(new SupportingFile("auth/oauth.mustache", authFolder, "oauth.dart"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
    }

    @Override
    public String escapeReservedWord(String name) {
        return name + "_";
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    @Override
    public String apiTestFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.testPackage().replace('/', File.separatorChar);
    }

    @Override
    public String apiDocFileFolder() {
        return (this.outputFolder + "/" + this.apiDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String modelDocFileFolder() {
        return (this.outputFolder + "/" + this.modelDocPath).replace('/', File.separatorChar);
    }

    @Override
    public String toVarName(String name) {
        if ((name = name.replaceAll("-", "_")).matches("^[A-Z_]*$")) {
            return name;
        }
        if ((name = DartClientCodegen.camelize(name, true)).matches("^\\d.*")) {
            name = "n" + name;
        }
        if (this.isReservedWord(name)) {
            name = this.escapeReservedWord(name);
        }
        return name;
    }

    @Override
    public String toParamName(String name) {
        return this.toVarName(name);
    }

    @Override
    public String toModelName(String name) {
        if (this.isReservedWord(name)) {
            LOGGER.warn(name + " (reserved word) cannot be used as model filename. Renamed to " + DartClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        if (Character.isDigit(name.charAt(0))) {
            LOGGER.warn(name + " start with number. Renamed to " + DartClientCodegen.camelize("model_" + name));
            name = "model_" + name;
        }
        return DartClientCodegen.camelize(name);
    }

    @Override
    public String toModelFilename(String name) {
        return DartClientCodegen.underscore(this.toModelName(name));
    }

    @Override
    public String toApiFilename(String name) {
        return DartClientCodegen.underscore(this.toApiName(name));
    }

    @Override
    public String toApiTestFilename(String name) {
        return DartClientCodegen.underscore(this.toApiName(name)) + "_test";
    }

    @Override
    public String toDefaultValue(Schema schema) {
        if (schema instanceof MapSchema) {
            return "{}";
        }
        if (schema instanceof ArraySchema) {
            return "[]";
        }
        if (schema instanceof StringSchema && schema.getDefault() != null) {
            String _default = schema.getDefault().toString();
            if (schema.getEnum() == null) {
                return String.format("\"%s\"", this.escapeText(_default));
            }
            return _default;
        }
        return super.toDefaultValue(schema);
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        MapSchema mp;
        Object innerObject;
        if (schema instanceof ArraySchema) {
            ArraySchema ap = (ArraySchema)schema;
            Schema inner = ap.getItems();
            return this.getSchemaType(schema) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (schema instanceof MapSchema && (innerObject = (mp = (MapSchema)schema).getAdditionalProperties()) instanceof Schema) {
            Schema inner = (Schema)innerObject;
            return this.getSchemaType(schema) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(schema);
    }

    @Override
    public String getSchemaType(Schema schema) {
        String swaggerType = super.getSchemaType(schema);
        String type = null;
        if (this.typeMapping.containsKey(swaggerType)) {
            type = (String)this.typeMapping.get(swaggerType);
            if (this.languageSpecificPrimitives.contains(type)) {
                return type;
            }
        } else {
            type = swaggerType;
        }
        if (type == null) {
            type = "Object";
        }
        return this.toModelName(type);
    }

    @Override
    public Map<String, Object> postProcessModels(Map<String, Object> objs) {
        return this.postProcessModelsEnum(objs);
    }

    @Override
    public Map<String, Object> postProcessModelsEnum(Map<String, Object> objs) {
        List models = (List)objs.get("models");
        for (Object _mo : models) {
            Map modelMap = (Map)_mo;
            CodegenModel codegenModel = (CodegenModel)modelMap.get("model");
            boolean succes = this.buildEnumFromVendorExtension(codegenModel) || this.buildEnumFromValues(codegenModel);
            for (CodegenProperty var : codegenModel.vars) {
                this.updateCodegenPropertyEnum(var);
            }
        }
        return objs;
    }

    private boolean buildEnumFromValues(CodegenModel codegenModel) {
        if (!ExtensionHelper.getBooleanValue((VendorExtendable)codegenModel, "x-is-enum") || codegenModel.allowableValues == null) {
            return false;
        }
        Map allowableValues = codegenModel.allowableValues;
        List values = (List)allowableValues.get("values");
        ArrayList enumVars = new ArrayList();
        String commonPrefix = this.findCommonPrefixOfVars(values);
        int truncateIdx = commonPrefix.length();
        for (Object value : values) {
            String enumName;
            HashMap<String, String> enumVar = new HashMap<String, String>();
            if (truncateIdx == 0) {
                enumName = value.toString();
            } else {
                enumName = value.toString().substring(truncateIdx);
                if ("".equals(enumName)) {
                    enumName = value.toString();
                }
            }
            enumVar.put("name", this.toEnumVarName(enumName, codegenModel.dataType));
            enumVar.put("value", this.toEnumValue(value.toString(), codegenModel.dataType));
            enumVars.add(enumVar);
        }
        codegenModel.allowableValues.put("enumVars", enumVars);
        return true;
    }

    private boolean buildEnumFromVendorExtension(CodegenModel codegenModel) {
        if (!(ExtensionHelper.getBooleanValue((VendorExtendable)codegenModel, "x-is-enum") && codegenModel.allowableValues != null && this.useEnumExtension && codegenModel.vendorExtensions.containsKey("x-enum-values"))) {
            return false;
        }
        Object extension = codegenModel.vendorExtensions.get("x-enum-values");
        List values = (List)extension;
        ArrayList enumVars = new ArrayList();
        for (Map value : values) {
            HashMap<String, String> enumVar = new HashMap<String, String>();
            String name = DartClientCodegen.camelize((String)value.get("identifier"), true);
            if (this.isReservedWord(name)) {
                name = this.escapeReservedWord(name);
            }
            enumVar.put("name", name);
            enumVar.put("value", this.toEnumValue(value.get("numericValue").toString(), codegenModel.dataType));
            if (value.containsKey("description")) {
                enumVar.put("description", value.get("description").toString());
            }
            enumVars.add(enumVar);
        }
        codegenModel.allowableValues.put("enumVars", enumVars);
        return true;
    }

    @Override
    public String toEnumVarName(String value, String datatype) {
        if (value.length() == 0) {
            return "empty";
        }
        String var = value.replaceAll("\\W+", "_");
        if ("number".equalsIgnoreCase(datatype) || "int".equalsIgnoreCase(datatype)) {
            var = "Number" + var;
        }
        return this.escapeReservedWord(DartClientCodegen.camelize(var, true));
    }

    @Override
    public String toEnumValue(String value, String datatype) {
        if ("number".equalsIgnoreCase(datatype) || "int".equalsIgnoreCase(datatype)) {
            return value;
        }
        return "\"" + this.escapeText(value) + "\"";
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            String newOperationId = DartClientCodegen.camelize("call_" + operationId, true);
            LOGGER.warn(operationId + " (reserved word) cannot be used as method name. Renamed to " + newOperationId);
            return newOperationId;
        }
        return DartClientCodegen.camelize(operationId, true);
    }

    public void setBrowserClient(boolean browserClient) {
        this.browserClient = browserClient;
    }

    public void setPubName(String pubName) {
        this.pubName = pubName;
    }

    public void setPubVersion(String pubVersion) {
        this.pubVersion = pubVersion;
    }

    public void setPubDescription(String pubDescription) {
        this.pubDescription = pubDescription;
    }

    public void setUseEnumExtension(boolean useEnumExtension) {
        this.useEnumExtension = useEnumExtension;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String getDefaultTemplateDir() {
        return "dart";
    }
}

