/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.web;

import io.swagger.annotations.Api;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Tags;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ApiListingBuilderPlugin;
import springfox.documentation.spi.service.contexts.ApiListingContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147482648)
public class SwaggerApiListingReader
implements ApiListingBuilderPlugin {
    public void apply(ApiListingContext apiListingContext) {
        Optional controller = apiListingContext.getResourceGroup().getControllerClass();
        if (controller.isPresent()) {
            Optional<Annotation> apiAnnotation = Optional.ofNullable(AnnotationUtils.findAnnotation((Class)((Class)controller.get()), Api.class));
            String description = apiAnnotation.map(Api::description).filter(((Predicate<String>)String::isEmpty).negate()).orElse(null);
            Set tagSet = apiAnnotation.map(this.tags()).orElse(new TreeSet());
            if (tagSet.isEmpty()) {
                tagSet.add(apiListingContext.getResourceGroup().getGroupName());
            }
            apiListingContext.apiListingBuilder().description(description).tagNames(tagSet);
        }
    }

    private Function<Api, Set<String>> tags() {
        return input -> Stream.of(input.tags()).filter(Tags.emptyTags()).collect(Collectors.toCollection(TreeSet::new));
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

