/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Parameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spring.web.DescriptionResolver;
import springfox.documentation.swagger.common.SwaggerPluginSupport;
import springfox.documentation.swagger.readers.operation.OperationImplicitParameterReader;

@Component
@Order(value=-2147482648)
public class OperationImplicitParametersReader
implements OperationBuilderPlugin {
    private final DescriptionResolver descriptions;

    @Autowired
    public OperationImplicitParametersReader(DescriptionResolver descriptions) {
        this.descriptions = descriptions;
    }

    public void apply(OperationContext context) {
        context.operationBuilder().parameters(this.readParameters(context));
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }

    private List<Parameter> readParameters(OperationContext context) {
        List annotations = context.findAllAnnotations(ApiImplicitParams.class);
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        if (!annotations.isEmpty()) {
            for (ApiImplicitParams annotation : annotations) {
                for (ApiImplicitParam param : annotation.value()) {
                    parameters.add(OperationImplicitParameterReader.implicitParameter(this.descriptions, param));
                }
            }
        }
        return parameters;
    }
}

