/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.scanners;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import springfox.documentation.service.ApiDescription;
import springfox.documentation.service.Operation;
import springfox.documentation.spi.service.contexts.ApiSelector;
import springfox.documentation.spi.service.contexts.PathContext;
import springfox.documentation.spi.service.contexts.RequestMappingContext;
import springfox.documentation.spring.web.plugins.DocumentationPluginsManager;
import springfox.documentation.spring.web.readers.operation.OperationReader;
import springfox.documentation.spring.web.scanners.ApiDescriptionLookup;
import springfox.documentation.spring.wrapper.PatternsRequestCondition;

@Component
public class ApiDescriptionReader {
    private static Logger log = LoggerFactory.getLogger(ApiDescriptionReader.class);
    private final OperationReader operationReader;
    private final DocumentationPluginsManager pluginsManager;
    private final ApiDescriptionLookup lookup;

    @Autowired
    public ApiDescriptionReader(@Qualifier(value="cachedOperations") OperationReader operationReader, DocumentationPluginsManager pluginsManager, ApiDescriptionLookup lookup) {
        this.operationReader = operationReader;
        this.pluginsManager = pluginsManager;
        this.lookup = lookup;
    }

    public List<ApiDescription> read(RequestMappingContext outerContext) {
        PatternsRequestCondition patternsCondition = outerContext.getPatternsCondition();
        ApiSelector selector = outerContext.getDocumentationContext().getApiSelector();
        ArrayList<ApiDescription> apiDescriptionList = new ArrayList<ApiDescription>();
        for (String path : this.matchingPaths(selector, patternsCondition)) {
            String methodName = outerContext.getName();
            try {
                RequestMappingContext operationContext = outerContext.copyPatternUsing(path).withKnownModels(outerContext.getModelMap());
                List<Operation> operations = this.operationReader.read(operationContext);
                if (operations.size() <= 0) continue;
                operationContext.apiDescriptionBuilder().groupName(outerContext.getGroupName()).operations(operations).pathDecorator(this.pluginsManager.decorator(new PathContext(outerContext, operations.stream().findFirst()))).path(path).description(methodName).hidden(false);
                ApiDescription apiDescription = operationContext.apiDescriptionBuilder().build();
                this.lookup.add(outerContext.key(), apiDescription);
                apiDescriptionList.add(apiDescription);
            }
            catch (Error e) {
                String contentMsg = "Skipping process path[" + path + "], method[" + methodName + "] as it has an error.";
                log.error(contentMsg, (Throwable)e);
            }
        }
        return apiDescriptionList;
    }

    private List<String> matchingPaths(ApiSelector selector, PatternsRequestCondition patternsCondition) {
        return patternsCondition.getPatterns().stream().filter(selector.getPathSelector()).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }
}

