/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import com.fasterxml.classmate.ResolvedType;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.BuilderDefaults;
import springfox.documentation.schema.ModelProperty;
import springfox.documentation.schema.Xml;
import springfox.documentation.service.AllowableValues;
import springfox.documentation.service.VendorExtension;

public class ModelPropertyBuilder {
    private ResolvedType type;
    private String qualifiedType;
    private int position;
    private Boolean required;
    private Boolean readOnly;
    private String description;
    private AllowableValues allowableValues;
    private String name;
    private boolean isHidden;
    private Object example;
    private String pattern;
    private String defaultValue;
    private Xml xml;
    private Boolean allowEmptyValue;
    private List<VendorExtension> vendorExtensions = new ArrayList<VendorExtension>();

    public ModelPropertyBuilder() {
    }

    public ModelPropertyBuilder(ModelProperty modelProperty) {
        this.type = modelProperty.getType();
        this.qualifiedType = modelProperty.getQualifiedType();
        this.position = modelProperty.getPosition();
        this.required = modelProperty.isRequired();
        this.readOnly = modelProperty.isReadOnly();
        this.description = modelProperty.getDescription();
        this.allowableValues = modelProperty.getAllowableValues();
        this.name = modelProperty.getName();
        this.isHidden = modelProperty.isHidden();
        this.example = modelProperty.getExample();
        this.pattern = modelProperty.getPattern();
        this.defaultValue = modelProperty.getDefaultValue();
        this.xml = modelProperty.getXml();
        this.allowEmptyValue = modelProperty.isAllowEmptyValue();
        this.vendorExtensions.addAll(modelProperty.getVendorExtensions());
    }

    public ModelPropertyBuilder name(String name) {
        this.name = BuilderDefaults.defaultIfAbsent(name, this.name);
        return this;
    }

    public ModelPropertyBuilder type(ResolvedType type) {
        this.type = BuilderDefaults.replaceIfMoreSpecific(type, this.type);
        return this;
    }

    public ModelPropertyBuilder qualifiedType(String qualifiedType) {
        this.qualifiedType = BuilderDefaults.defaultIfAbsent(qualifiedType, this.qualifiedType);
        return this;
    }

    public ModelPropertyBuilder position(int position) {
        this.position = position;
        return this;
    }

    public ModelPropertyBuilder required(Boolean required) {
        this.required = required;
        return this;
    }

    public ModelPropertyBuilder readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    public ModelPropertyBuilder description(String description) {
        this.description = BuilderDefaults.defaultIfAbsent(description, this.description);
        return this;
    }

    @Deprecated
    public ModelPropertyBuilder example(String example) {
        this.example = BuilderDefaults.defaultIfAbsent(example, this.example);
        return this;
    }

    public ModelPropertyBuilder example(Object example) {
        this.example = BuilderDefaults.defaultIfAbsent(example, this.example);
        return this;
    }

    public ModelPropertyBuilder allowableValues(AllowableValues allowableValues) {
        this.allowableValues = BuilderDefaults.emptyToNull(allowableValues, this.allowableValues);
        return this;
    }

    public ModelPropertyBuilder isHidden(Boolean isHidden) {
        this.isHidden = isHidden;
        return this;
    }

    public ModelPropertyBuilder pattern(String pattern) {
        this.pattern = BuilderDefaults.defaultIfAbsent(pattern, this.pattern);
        return this;
    }

    public ModelPropertyBuilder extensions(List<VendorExtension> extensions) {
        this.vendorExtensions.addAll(BuilderDefaults.nullToEmptyList(extensions));
        return this;
    }

    public ModelPropertyBuilder defaultValue(String defaultValue) {
        this.defaultValue = BuilderDefaults.defaultIfAbsent(defaultValue, this.defaultValue);
        return this;
    }

    public ModelPropertyBuilder allowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
        return this;
    }

    public ModelPropertyBuilder xml(Xml xml) {
        this.xml = BuilderDefaults.defaultIfAbsent(xml, this.xml);
        return this;
    }

    public ModelProperty build() {
        if (this.xml != null && StringUtils.isEmpty((Object)this.xml.getName())) {
            this.xml.setName(this.name);
        }
        return new ModelProperty(this.name, this.type, this.qualifiedType, this.position, this.required == null ? false : this.required, this.isHidden, this.readOnly == null ? false : this.readOnly, this.allowEmptyValue, this.description, this.allowableValues, this.example, this.pattern, this.defaultValue, this.xml, this.vendorExtensions);
    }
}

