/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.support;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Agent {
    private final AgentId id;
    private final String version;

    public Agent(AgentId id, String version) {
        this.id = id;
        this.version = version;
    }

    public AgentId getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public static Agent fromUserAgent(String userAgent) {
        return UserAgentHandler.parse(userAgent);
    }

    public static enum AgentId {
        CURL("curl", "curl"),
        HTTPIE("httpie", "HTTPie"),
        JBOSS_FORGE("jbossforge", "SpringBootForgeCli"),
        SPRING_BOOT_CLI("spring", "SpringBootCli"),
        STS("sts", "STS"),
        INTELLIJ_IDEA("intellijidea", "IntelliJ IDEA"),
        NETBEANS("netbeans", "NetBeans"),
        VSCODE("vscode", "vscode"),
        JENKINSX("jenkinsx", "jx"),
        NX("nx", "@nxrocks_nx-spring-boot"),
        BROWSER("browser", "Browser");

        final String id;
        final String name;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        private AgentId(String id, String name) {
            this.id = id;
            this.name = name;
        }
    }

    private static final class UserAgentHandler {
        private static final Pattern TOOL_REGEX = Pattern.compile("([^\\/]*)\\/([^ ]*).*");
        private static final Pattern STS_REGEX = Pattern.compile("STS (.*)");
        private static final Pattern NETBEANS_REGEX = Pattern.compile("nb-springboot-plugin\\/(.*)");

        private UserAgentHandler() {
        }

        static Agent parse(String userAgent) {
            Matcher matcher = TOOL_REGEX.matcher(userAgent);
            if (matcher.matches()) {
                String name = matcher.group(1);
                for (AgentId id : AgentId.values()) {
                    if (!name.equals(id.name)) continue;
                    String version = matcher.group(2);
                    return new Agent(id, version);
                }
            }
            if ((matcher = STS_REGEX.matcher(userAgent)).matches()) {
                return new Agent(AgentId.STS, matcher.group(1));
            }
            matcher = NETBEANS_REGEX.matcher(userAgent);
            if (matcher.matches()) {
                return new Agent(AgentId.NETBEANS, matcher.group(1));
            }
            if (userAgent.equals(AgentId.INTELLIJ_IDEA.name)) {
                return new Agent(AgentId.INTELLIJ_IDEA, null);
            }
            if (userAgent.contains("Mozilla/5.0")) {
                return new Agent(AgentId.BROWSER, null);
            }
            return null;
        }
    }
}

